/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.facet;

import guideme.internal.shaded.lucene.document.BinaryDocValuesField;
import guideme.internal.shaded.lucene.document.Document;
import guideme.internal.shaded.lucene.document.Field;
import guideme.internal.shaded.lucene.document.SortedNumericDocValuesField;
import guideme.internal.shaded.lucene.document.SortedSetDocValuesField;
import guideme.internal.shaded.lucene.document.StringField;
import guideme.internal.shaded.lucene.facet.FacetField;
import guideme.internal.shaded.lucene.facet.sortedset.SortedSetDocValuesFacetField;
import guideme.internal.shaded.lucene.facet.taxonomy.AssociationFacetField;
import guideme.internal.shaded.lucene.facet.taxonomy.FacetLabel;
import guideme.internal.shaded.lucene.facet.taxonomy.FloatAssociationFacetField;
import guideme.internal.shaded.lucene.facet.taxonomy.IntAssociationFacetField;
import guideme.internal.shaded.lucene.facet.taxonomy.TaxonomyWriter;
import guideme.internal.shaded.lucene.index.IndexableField;
import guideme.internal.shaded.lucene.index.IndexableFieldType;
import guideme.internal.shaded.lucene.util.ArrayUtil;
import guideme.internal.shaded.lucene.util.BitUtil;
import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.IntsRef;
import guideme.internal.shaded.lucene.util.IntsRefBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class FacetsConfig {
    public static final String DEFAULT_INDEX_FIELD_NAME = "$facets";
    private final Map<String, DimConfig> fieldTypes = new ConcurrentHashMap<String, DimConfig>();
    private final Map<String, String> assocDimTypes = new ConcurrentHashMap<String, String>();
    public static final DimConfig DEFAULT_DIM_CONFIG = new DimConfig();
    public static final char DELIM_CHAR = '\u001f';
    private static final char ESCAPE_CHAR = '\u001e';

    protected DimConfig getDefaultDimConfig() {
        return DEFAULT_DIM_CONFIG;
    }

    public DimConfig getDimConfig(String dimName) {
        DimConfig dimConfig = this.fieldTypes.get(dimName);
        if (dimConfig == null) {
            dimConfig = this.getDefaultDimConfig();
        }
        return dimConfig;
    }

    public boolean isDimConfigured(String dimName) {
        return this.fieldTypes.get(dimName) != null;
    }

    public synchronized void setHierarchical(String dimName, boolean v) {
        DimConfig dimConfig = this.fieldTypes.get(dimName);
        if (dimConfig == null) {
            dimConfig = new DimConfig();
            this.fieldTypes.put(dimName, dimConfig);
        }
        dimConfig.hierarchical = v;
    }

    public synchronized void setMultiValued(String dimName, boolean value) {
        DimConfig dimConfig = this.fieldTypes.get(dimName);
        if (dimConfig == null) {
            dimConfig = new DimConfig();
            this.fieldTypes.put(dimName, dimConfig);
        }
        dimConfig.multiValued = value;
    }

    public synchronized void setRequireDimCount(String dimName, boolean value) {
        DimConfig dimConfig = this.fieldTypes.get(dimName);
        if (dimConfig == null) {
            dimConfig = new DimConfig();
            this.fieldTypes.put(dimName, dimConfig);
        }
        dimConfig.requireDimCount = value;
    }

    public synchronized void setIndexFieldName(String dimName, String indexFieldName) {
        DimConfig dimConfig = this.fieldTypes.get(dimName);
        if (dimConfig == null) {
            dimConfig = new DimConfig();
            this.fieldTypes.put(dimName, dimConfig);
        }
        dimConfig.indexFieldName = indexFieldName;
    }

    public synchronized void setDrillDownTermsIndexing(String dimName, DrillDownTermsIndexing drillDownTermsIndexing) {
        DimConfig dimConfig = this.fieldTypes.get(dimName);
        if (dimConfig == null) {
            dimConfig = new DimConfig();
            this.fieldTypes.put(dimName, dimConfig);
        }
        dimConfig.drillDownTermsIndexing = drillDownTermsIndexing;
    }

    public Map<String, DimConfig> getDimConfigs() {
        return this.fieldTypes;
    }

    private static void checkSeen(Set<String> seenDims, String dim) {
        if (seenDims.contains(dim)) {
            throw new IllegalArgumentException("dimension \"" + dim + "\" is not multiValued, but it appears more than once in this document");
        }
        seenDims.add(dim);
    }

    public Document build(Document doc) throws IOException {
        return this.build(null, doc);
    }

    public Document build(TaxonomyWriter taxoWriter, Document doc) throws IOException {
        HashMap<String, List<FacetField>> byField = new HashMap<String, List<FacetField>>();
        HashMap<String, List<SortedSetDocValuesFacetField>> dvByField = new HashMap<String, List<SortedSetDocValuesFacetField>>();
        HashMap<String, List<AssociationFacetField>> assocByField = new HashMap<String, List<AssociationFacetField>>();
        HashSet<String> seenDims = new HashSet<String>();
        for (IndexableField field : doc) {
            List fields;
            String indexFieldName;
            DimConfig dimConfig;
            Field facetField;
            if (field.fieldType() == FacetField.TYPE) {
                facetField = (FacetField)field;
                dimConfig = this.getDimConfig(facetField.dim);
                if (!dimConfig.multiValued) {
                    FacetsConfig.checkSeen(seenDims, facetField.dim);
                }
                indexFieldName = dimConfig.indexFieldName;
                fields = byField.computeIfAbsent(indexFieldName, k -> new ArrayList());
                fields.add(facetField);
            }
            if (field.fieldType() == SortedSetDocValuesFacetField.TYPE) {
                facetField = (SortedSetDocValuesFacetField)field;
                dimConfig = this.getDimConfig(((SortedSetDocValuesFacetField)facetField).dim);
                if (!dimConfig.multiValued) {
                    FacetsConfig.checkSeen(seenDims, ((SortedSetDocValuesFacetField)facetField).dim);
                }
                indexFieldName = dimConfig.indexFieldName;
                fields = dvByField.computeIfAbsent(indexFieldName, k -> new ArrayList());
                fields.add(facetField);
            }
            if (field.fieldType() != AssociationFacetField.TYPE) continue;
            facetField = (AssociationFacetField)field;
            dimConfig = this.getDimConfig(((AssociationFacetField)facetField).dim);
            if (!dimConfig.multiValued) {
                FacetsConfig.checkSeen(seenDims, ((AssociationFacetField)facetField).dim);
            }
            if (dimConfig.hierarchical) {
                throw new IllegalArgumentException("AssociationFacetField cannot be hierarchical (dim=\"" + ((AssociationFacetField)facetField).dim + "\")");
            }
            if (dimConfig.requireDimCount) {
                throw new IllegalArgumentException("AssociationFacetField cannot requireDimCount (dim=\"" + ((AssociationFacetField)facetField).dim + "\")");
            }
            indexFieldName = dimConfig.indexFieldName;
            fields = assocByField.computeIfAbsent(indexFieldName, k -> new ArrayList());
            fields.add(facetField);
            String type = facetField instanceof IntAssociationFacetField ? "int" : (facetField instanceof FloatAssociationFacetField ? "float" : "bytes");
            String curType = this.assocDimTypes.get(indexFieldName);
            if (curType == null) {
                this.assocDimTypes.put(indexFieldName, type);
                continue;
            }
            if (curType.equals(type)) continue;
            throw new IllegalArgumentException("mixing incompatible types of AssociationFacetField (" + curType + " and " + type + ") in indexed field \"" + indexFieldName + "\"; use FacetsConfig to change the indexFieldName for each dimension");
        }
        Document result = new Document();
        this.processFacetFields(taxoWriter, byField, result);
        this.processSSDVFacetFields(dvByField, result);
        this.processAssocFacetFields(taxoWriter, assocByField, result);
        for (IndexableField field : doc.getFields()) {
            IndexableFieldType ft = field.fieldType();
            if (ft == FacetField.TYPE || ft == SortedSetDocValuesFacetField.TYPE || ft == AssociationFacetField.TYPE) continue;
            result.add(field);
        }
        return result;
    }

    private void processFacetFields(TaxonomyWriter taxoWriter, Map<String, List<FacetField>> byField, Document doc) throws IOException {
        for (Map.Entry<String, List<FacetField>> ent : byField.entrySet()) {
            String indexFieldName = ent.getKey();
            IntsRefBuilder ordinals = new IntsRefBuilder();
            for (FacetField facetField : ent.getValue()) {
                DimConfig dimConfig = this.getDimConfig(facetField.dim);
                if (facetField.path.length > 1 && !dimConfig.hierarchical) {
                    throw new IllegalArgumentException("dimension \"" + facetField.dim + "\" is not hierarchical yet has " + facetField.path.length + " components");
                }
                FacetLabel facetLabel = new FacetLabel(facetField.dim, facetField.path);
                this.checkTaxoWriter(taxoWriter);
                int ordinal = taxoWriter.addCategory(facetLabel);
                ordinals.append(ordinal);
                if (dimConfig.multiValued && (dimConfig.hierarchical || dimConfig.requireDimCount)) {
                    int parent = taxoWriter.getParent(ordinal);
                    while (parent > 0) {
                        ordinals.append(parent);
                        parent = taxoWriter.getParent(parent);
                    }
                    if (!dimConfig.requireDimCount) {
                        ordinals.setLength(ordinals.length() - 1);
                    }
                }
                this.indexDrillDownTerms(doc, indexFieldName, dimConfig, facetLabel);
            }
            IntsRef ords = ordinals.get();
            Arrays.sort(ords.ints, ords.offset, ords.offset + ords.length);
            int prev = -1;
            for (int i = 0; i < ords.length; ++i) {
                int ord = ords.ints[ords.offset + i];
                if (ord <= prev) continue;
                doc.add(new SortedNumericDocValuesField(indexFieldName, ord));
                prev = ord;
            }
        }
    }

    private void indexDrillDownTerms(Document doc, String indexFieldName, DimConfig dimConfig, FacetLabel facetLabel) {
        if (dimConfig.drillDownTermsIndexing != DrillDownTermsIndexing.NONE) {
            doc.add(new StringField(indexFieldName, FacetsConfig.pathToString(facetLabel.components, facetLabel.length), Field.Store.NO));
            switch (dimConfig.drillDownTermsIndexing.ordinal()) {
                case 0: 
                case 1: {
                    break;
                }
                case 3: {
                    doc.add(new StringField(indexFieldName, FacetsConfig.pathToString(facetLabel.components, 1), Field.Store.NO));
                    break;
                }
                case 2: {
                    for (int i = 2; i < facetLabel.length; ++i) {
                        doc.add(new StringField(indexFieldName, FacetsConfig.pathToString(facetLabel.components, i), Field.Store.NO));
                    }
                    break;
                }
                case 4: {
                    for (int i = 1; i < facetLabel.length; ++i) {
                        doc.add(new StringField(indexFieldName, FacetsConfig.pathToString(facetLabel.components, i), Field.Store.NO));
                    }
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Drill down term indexing option " + String.valueOf((Object)dimConfig.drillDownTermsIndexing) + " is not supported."));
                }
            }
        }
    }

    private void processSSDVFacetFields(Map<String, List<SortedSetDocValuesFacetField>> byField, Document doc) {
        for (Map.Entry<String, List<SortedSetDocValuesFacetField>> ent : byField.entrySet()) {
            String indexFieldName = ent.getKey();
            for (SortedSetDocValuesFacetField facetField : ent.getValue()) {
                FacetLabel facetLabel = new FacetLabel(facetField.dim, facetField.path);
                DimConfig dimConfig = this.getDimConfig(facetField.dim);
                if (dimConfig.hierarchical) {
                    for (int i = 0; i < facetLabel.length; ++i) {
                        String fullPath = FacetsConfig.pathToString(facetLabel.components, i + 1);
                        doc.add(new SortedSetDocValuesField(indexFieldName, new BytesRef(fullPath)));
                    }
                } else {
                    if (facetLabel.length != 2) {
                        throw new IllegalArgumentException("dimension \"" + facetField.dim + "\" is not hierarchical yet has " + facetField.path.length + " components");
                    }
                    if (dimConfig.multiValued && dimConfig.requireDimCount) {
                        doc.add(new SortedSetDocValuesField(indexFieldName, new BytesRef(facetField.dim)));
                    }
                    String fullPath = FacetsConfig.pathToString(facetLabel.components, facetLabel.length);
                    doc.add(new SortedSetDocValuesField(indexFieldName, new BytesRef(fullPath)));
                }
                this.indexDrillDownTerms(doc, indexFieldName, dimConfig, facetLabel);
            }
        }
    }

    private void processAssocFacetFields(TaxonomyWriter taxoWriter, Map<String, List<AssociationFacetField>> byField, Document doc) throws IOException {
        for (Map.Entry<String, List<AssociationFacetField>> ent : byField.entrySet()) {
            byte[] bytes = new byte[16];
            int upto = 0;
            String indexFieldName = ent.getKey();
            for (AssociationFacetField field : ent.getValue()) {
                this.checkTaxoWriter(taxoWriter);
                FacetLabel facetLabel = new FacetLabel(field.dim, field.path);
                int ordinal = taxoWriter.addCategory(facetLabel);
                if (upto + 4 > bytes.length) {
                    bytes = ArrayUtil.grow(bytes, upto + 4);
                }
                BitUtil.VH_BE_INT.set(bytes, upto, ordinal);
                if ((upto += 4) + field.assoc.length > bytes.length) {
                    bytes = ArrayUtil.grow(bytes, upto + field.assoc.length);
                }
                System.arraycopy(field.assoc.bytes, field.assoc.offset, bytes, upto, field.assoc.length);
                upto += field.assoc.length;
                this.indexDrillDownTerms(doc, indexFieldName, this.getDimConfig(field.dim), facetLabel);
            }
            doc.add(new BinaryDocValuesField(indexFieldName, new BytesRef(bytes, 0, upto)));
        }
    }

    private void checkTaxoWriter(TaxonomyWriter taxoWriter) {
        if (taxoWriter == null) {
            throw new IllegalStateException("a non-null TaxonomyWriter must be provided when indexing FacetField or AssociationFacetField");
        }
    }

    public static String pathToString(String dim, String ... path) {
        String[] fullPath = new String[1 + path.length];
        fullPath[0] = dim;
        System.arraycopy(path, 0, fullPath, 1, path.length);
        return FacetsConfig.pathToString(fullPath, fullPath.length);
    }

    public static String pathToString(String[] path) {
        return FacetsConfig.pathToString(path, path.length);
    }

    public static String pathToString(String[] path, int length) {
        if (length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            String s = path[i];
            if (s.length() == 0) {
                throw new IllegalArgumentException("each path component must have length > 0 (got: \"\")");
            }
            int numChars = s.length();
            for (int j = 0; j < numChars; ++j) {
                char ch = s.charAt(j);
                if (ch == '\u001f' || ch == '\u001e') {
                    sb.append('\u001e');
                }
                sb.append(ch);
            }
            sb.append('\u001f');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public static String[] stringToPath(String s) {
        ArrayList<String> parts = new ArrayList<String>();
        int length = s.length();
        if (length == 0) {
            return new String[0];
        }
        char[] buffer = new char[length];
        int upto = 0;
        boolean lastEscape = false;
        for (int i = 0; i < length; ++i) {
            char ch = s.charAt(i);
            if (lastEscape) {
                buffer[upto++] = ch;
                lastEscape = false;
                continue;
            }
            if (ch == '\u001e') {
                lastEscape = true;
                continue;
            }
            if (ch == '\u001f') {
                parts.add(new String(buffer, 0, upto));
                upto = 0;
                continue;
            }
            buffer[upto++] = ch;
        }
        parts.add(new String(buffer, 0, upto));
        assert (!lastEscape);
        return parts.toArray(new String[0]);
    }

    public static final class DimConfig {
        public boolean hierarchical;
        public boolean multiValued;
        public boolean requireDimCount;
        public DrillDownTermsIndexing drillDownTermsIndexing = DrillDownTermsIndexing.ALL;
        public String indexFieldName = "$facets";
    }

    public static enum DrillDownTermsIndexing {
        NONE,
        FULL_PATH_ONLY,
        ALL_PATHS_NO_DIM,
        DIMENSION_AND_FULL_PATH,
        ALL;

    }
}

