/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.document;

import guideme.internal.shaded.lucene.document.Field;
import guideme.internal.shaded.lucene.document.FieldType;
import guideme.internal.shaded.lucene.document.LatLonDocValuesBoxQuery;
import guideme.internal.shaded.lucene.document.LatLonDocValuesQuery;
import guideme.internal.shaded.lucene.document.LatLonPointSortField;
import guideme.internal.shaded.lucene.document.ShapeField;
import guideme.internal.shaded.lucene.geo.Circle;
import guideme.internal.shaded.lucene.geo.GeoEncodingUtils;
import guideme.internal.shaded.lucene.geo.LatLonGeometry;
import guideme.internal.shaded.lucene.geo.Point;
import guideme.internal.shaded.lucene.geo.Polygon;
import guideme.internal.shaded.lucene.geo.Rectangle;
import guideme.internal.shaded.lucene.index.DocValuesType;
import guideme.internal.shaded.lucene.index.FieldInfo;
import guideme.internal.shaded.lucene.search.MatchNoDocsQuery;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.search.SortField;

public class LatLonDocValuesField
extends Field {
    public static final FieldType TYPE = new FieldType();

    public LatLonDocValuesField(String name, double latitude, double longitude) {
        super(name, TYPE);
        this.setLocationValue(latitude, longitude);
    }

    public void setLocationValue(double latitude, double longitude) {
        int latitudeEncoded = GeoEncodingUtils.encodeLatitude(latitude);
        int longitudeEncoded = GeoEncodingUtils.encodeLongitude(longitude);
        this.fieldsData = (long)latitudeEncoded << 32 | (long)longitudeEncoded & 0xFFFFFFFFL;
    }

    static void checkCompatible(FieldInfo fieldInfo) {
        if (fieldInfo.getDocValuesType() != DocValuesType.NONE && fieldInfo.getDocValuesType() != TYPE.docValuesType()) {
            throw new IllegalArgumentException("field=\"" + fieldInfo.name + "\" was indexed with docValuesType=" + String.valueOf((Object)fieldInfo.getDocValuesType()) + " but this type has docValuesType=" + String.valueOf((Object)TYPE.docValuesType()) + ", is the field really a LatLonDocValuesField?");
        }
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName());
        result.append(" <");
        result.append(this.name);
        result.append(':');
        long currentValue = (Long)this.fieldsData;
        result.append(GeoEncodingUtils.decodeLatitude((int)(currentValue >> 32)));
        result.append(',');
        result.append(GeoEncodingUtils.decodeLongitude((int)(currentValue & 0xFFFFFFFFFFFFFFFFL)));
        result.append('>');
        return result.toString();
    }

    public static SortField newDistanceSort(String field, double latitude, double longitude) {
        return new LatLonPointSortField(field, latitude, longitude);
    }

    public static Query newSlowBoxQuery(String field, double minLatitude, double maxLatitude, double minLongitude, double maxLongitude) {
        if (minLatitude == 90.0) {
            return new MatchNoDocsQuery("LatLonDocValuesField.newBoxQuery with minLatitude=90.0");
        }
        if (minLongitude == 180.0) {
            if (maxLongitude == 180.0) {
                return new MatchNoDocsQuery("LatLonDocValuesField.newBoxQuery with minLongitude=maxLongitude=180.0");
            }
            if (maxLongitude < minLongitude) {
                minLongitude = -180.0;
            }
        }
        return new LatLonDocValuesBoxQuery(field, minLatitude, maxLatitude, minLongitude, maxLongitude);
    }

    public static Query newSlowDistanceQuery(String field, double latitude, double longitude, double radiusMeters) {
        Circle circle = new Circle(latitude, longitude, radiusMeters);
        return LatLonDocValuesField.newSlowGeometryQuery(field, ShapeField.QueryRelation.INTERSECTS, circle);
    }

    public static Query newSlowPolygonQuery(String field, Polygon ... polygons) {
        return LatLonDocValuesField.newSlowGeometryQuery(field, ShapeField.QueryRelation.INTERSECTS, polygons);
    }

    public static Query newSlowGeometryQuery(String field, ShapeField.QueryRelation queryRelation, LatLonGeometry ... latLonGeometries) {
        if (queryRelation == ShapeField.QueryRelation.INTERSECTS && latLonGeometries.length == 1 && latLonGeometries[0] instanceof Rectangle) {
            LatLonGeometry geometry = latLonGeometries[0];
            Rectangle rect = (Rectangle)geometry;
            return LatLonDocValuesField.newSlowBoxQuery(field, rect.minLat, rect.maxLat, rect.minLon, rect.maxLon);
        }
        if (queryRelation == ShapeField.QueryRelation.CONTAINS) {
            for (LatLonGeometry geometry : latLonGeometries) {
                if (geometry instanceof Point) continue;
                return new MatchNoDocsQuery("Contains LatLonDocValuesField.newSlowGeometryQuery with non-point geometries");
            }
        }
        return new LatLonDocValuesQuery(field, queryRelation, latLonGeometries);
    }

    static {
        TYPE.setDocValuesType(DocValuesType.SORTED_NUMERIC);
        TYPE.freeze();
    }
}

