/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.search;

import guideme.internal.search.Analyzers;
import guideme.internal.shaded.lucene.analysis.Analyzer;
import guideme.internal.shaded.lucene.analysis.DelegatingAnalyzerWrapper;
import guideme.internal.shaded.lucene.analysis.standard.StandardAnalyzer;
import java.util.Objects;

public class LanguageSpecificAnalyzerWrapper
extends DelegatingAnalyzerWrapper {
    private final Analyzer defaultAnalyzer = new StandardAnalyzer();

    public LanguageSpecificAnalyzerWrapper() {
        super(PER_FIELD_REUSE_STRATEGY);
    }

    @Override
    protected Analyzer getWrappedAnalyzer(String fieldName) {
        if (fieldName == null) {
            return this.defaultAnalyzer;
        }
        for (String language : Analyzers.LANGUAGES) {
            if (!fieldName.endsWith("_" + language)) continue;
            return Objects.requireNonNull(Analyzers.ANALYZERS.get(language), "analyzer for " + language).get();
        }
        return this.defaultAnalyzer;
    }
}

