/*
 * Decompiled with CFR 0.152.
 */
package guideme.document.flow;

import guideme.document.LytRect;
import guideme.document.LytSize;
import guideme.document.block.LytBlock;
import guideme.document.block.LytVisitor;
import guideme.document.flow.InlineBlockAlignment;
import guideme.document.flow.LytFlowContent;
import guideme.document.interaction.GuideTooltip;
import guideme.document.interaction.InteractiveElement;
import guideme.layout.LayoutContext;
import guideme.layout.MinecraftFontMetrics;
import guideme.ui.GuideUiHost;
import java.util.Optional;

public class LytFlowInlineBlock
extends LytFlowContent
implements InteractiveElement {
    private LytBlock block;
    private InlineBlockAlignment alignment = InlineBlockAlignment.INLINE;

    public LytBlock getBlock() {
        return this.block;
    }

    public void setBlock(LytBlock block) {
        this.block = block;
    }

    public InlineBlockAlignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(InlineBlockAlignment alignment) {
        this.alignment = alignment;
    }

    public LytSize getPreferredSize(int lineWidth) {
        if (this.block == null) {
            return LytSize.empty();
        }
        LayoutContext layoutContext = new LayoutContext(new MinecraftFontMetrics());
        LytRect bounds = this.block.layout(layoutContext, 0, 0, lineWidth);
        return new LytSize(bounds.right(), bounds.bottom());
    }

    @Override
    public boolean mouseClicked(GuideUiHost screen, int x, int y, int button) {
        LytBlock lytBlock = this.block;
        if (lytBlock instanceof InteractiveElement) {
            InteractiveElement interactiveElement = (InteractiveElement)((Object)lytBlock);
            return interactiveElement.mouseClicked(screen, x, y, button);
        }
        return false;
    }

    @Override
    public boolean mouseReleased(GuideUiHost screen, int x, int y, int button) {
        LytBlock lytBlock = this.block;
        if (lytBlock instanceof InteractiveElement) {
            InteractiveElement interactiveElement = (InteractiveElement)((Object)lytBlock);
            return interactiveElement.mouseReleased(screen, x, y, button);
        }
        return false;
    }

    @Override
    public Optional<GuideTooltip> getTooltip(float x, float y) {
        LytBlock lytBlock = this.block;
        if (lytBlock instanceof InteractiveElement) {
            InteractiveElement interactiveElement = (InteractiveElement)((Object)lytBlock);
            return interactiveElement.getTooltip(x, y);
        }
        return Optional.empty();
    }

    @Override
    protected void visitChildren(LytVisitor visitor) {
        if (this.block != null) {
            this.block.visit(visitor);
        }
    }

    public static LytFlowInlineBlock of(LytBlock block) {
        LytFlowInlineBlock inlineBlock = new LytFlowInlineBlock();
        inlineBlock.setBlock(block);
        return inlineBlock;
    }
}

