/*
 * Decompiled with CFR 0.152.
 */
package guideme.document.block;

import guideme.color.SymbolicColor;
import guideme.document.LytRect;
import guideme.document.block.BorderRenderer;
import guideme.document.block.LytBlock;
import guideme.document.block.LytBlockContainer;
import guideme.document.block.LytNode;
import guideme.layout.LayoutContext;
import guideme.render.RenderContext;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import org.jetbrains.annotations.Nullable;

public abstract class LytBox
extends LytBlock
implements LytBlockContainer {
    protected final List<LytBlock> children = new ArrayList<LytBlock>();
    protected int paddingLeft;
    protected int paddingTop;
    protected int paddingRight;
    protected int paddingBottom;
    private final BorderRenderer borderRenderer = new BorderRenderer();
    @Nullable
    private SymbolicColor backgroundColor;

    @Override
    public void removeChild(LytNode node) {
        if (node instanceof LytBlock) {
            LytBlock block = (LytBlock)node;
            if (block.parent == this) {
                this.children.remove(block);
                block.parent = null;
            }
        }
    }

    @Override
    public void append(LytBlock block) {
        if (block.parent != null) {
            block.parent.removeChild(block);
        }
        block.parent = this;
        this.children.add(block);
    }

    public void clearContent() {
        for (LytBlock child : this.children) {
            child.parent = null;
        }
        this.children.clear();
    }

    protected abstract LytRect computeBoxLayout(LayoutContext var1, int var2, int var3, int var4);

    @Override
    protected final LytRect computeLayout(LayoutContext context, int x, int y, int availableWidth) {
        int borderTop = this.getBorderTop().width();
        int borderLeft = this.getBorderLeft().width();
        int borderRight = this.getBorderRight().width();
        int borderBottom = this.getBorderBottom().width();
        LytRect innerLayout = this.computeBoxLayout(context, x + this.paddingLeft + borderLeft, y + this.paddingTop + borderTop, availableWidth - this.paddingLeft - this.paddingRight - borderLeft - borderRight);
        return innerLayout.expand(this.paddingLeft + borderLeft, this.paddingTop + borderTop, this.paddingRight + borderRight, this.paddingBottom + borderBottom);
    }

    @Override
    protected void onLayoutMoved(int deltaX, int deltaY) {
        for (LytBlock child : this.children) {
            child.setLayoutPos(child.bounds.point().add(deltaX, deltaY));
        }
    }

    public final void setPadding(int padding) {
        this.paddingLeft = padding;
        this.paddingTop = padding;
        this.paddingRight = padding;
        this.paddingBottom = padding;
    }

    public void setPaddingLeft(int paddingLeft) {
        this.paddingLeft = paddingLeft;
    }

    public void setPaddingTop(int paddingTop) {
        this.paddingTop = paddingTop;
    }

    public void setPaddingRight(int paddingRight) {
        this.paddingRight = paddingRight;
    }

    public void setPaddingBottom(int paddingBottom) {
        this.paddingBottom = paddingBottom;
    }

    @Nullable
    public SymbolicColor getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(@Nullable SymbolicColor backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @Override
    public List<? extends LytNode> getChildren() {
        return this.children;
    }

    @Override
    public void renderBatch(RenderContext context, MultiBufferSource buffers) {
        context.poseStack().pushPose();
        context.poseStack().translate(0.0, 0.0, 0.1);
        for (LytBlock child : this.children) {
            child.renderBatch(context, buffers);
        }
        context.poseStack().popPose();
    }

    @Override
    public void render(RenderContext context) {
        if (this.backgroundColor != null) {
            context.fillRect(this.bounds, this.backgroundColor);
        }
        context.poseStack().pushPose();
        context.poseStack().translate(0.0, 0.0, 0.1);
        for (LytBlock child : this.children) {
            child.render(context);
        }
        context.poseStack().translate(0.0, 0.0, 0.1);
        this.borderRenderer.render(context, this.bounds, this.getBorderTop(), this.getBorderLeft(), this.getBorderRight(), this.getBorderBottom());
        context.poseStack().popPose();
    }
}

