/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.mixins.common;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tech.alexnijjar.golemoverhaul.common.entities.AdditionalBeeData;
import tech.alexnijjar.golemoverhaul.common.entities.goals.GoToHoneyGolemHiveGoal;
import tech.alexnijjar.golemoverhaul.common.entities.goals.LocateHoneyGolemHiveGoal;
import tech.alexnijjar.golemoverhaul.common.entities.golems.HoneyGolem;

@Mixin(value={Bee.class})
public abstract class BeeMixin
extends PathfinderMob
implements AdditionalBeeData {
    @Unique
    @Nullable
    private UUID golemoverhaul$owner;

    protected BeeMixin(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"registerGoals"}, at={@At(value="TAIL")})
    private void golemoverhaul$registerGoals(CallbackInfo ci) {
        Bee bee = (Bee)this;
        this.goalSelector.addGoal(5, (Goal)new LocateHoneyGolemHiveGoal(bee));
        this.goalSelector.addGoal(6, (Goal)new GoToHoneyGolemHiveGoal(bee));
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void golemoverhaul$tick(CallbackInfo ci) {
        Level level;
        if (this.tickCount + this.getId() % 40 == 0 && this.getTarget() == null && (level = this.level()) instanceof ServerLevel) {
            HoneyGolem golem;
            Entity entity;
            ServerLevel level2 = (ServerLevel)level;
            if (this.golemoverhaul$owner != null && (entity = level2.getEntity(this.golemoverhaul$owner)) instanceof HoneyGolem && (golem = (HoneyGolem)entity).getTarget() != null) {
                this.setTarget(golem.getTarget());
            }
        }
    }

    @Inject(method={"setHasStung"}, at={@At(value="HEAD")}, cancellable=true)
    private void golemoverhaul$setHasStung(boolean hasStung, CallbackInfo ci) {
        if (hasStung && this.golemoverhaul$owner != null) {
            ci.cancel();
        }
    }

    @WrapWithCondition(method={"doHurtTarget"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/animal/Bee;stopBeingAngry()V")})
    private boolean golemoverhaul$doHurtTarget(Bee instance) {
        return this.golemoverhaul$owner == null;
    }

    @WrapOperation(method={"doHurtTarget"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/animal/Bee;getAttributeValue(Lnet/minecraft/core/Holder;)D")})
    private double golemoverhaul$doHurtTarget2(Bee instance, Holder<Attribute> holder, Operation<Double> original) {
        return (Double)original.call(new Object[]{instance, holder}) * (double)(this.golemoverhaul$owner != null ? 6 : 1);
    }

    @Override
    @Nullable
    public UUID golemoverhaul$getOwner() {
        return this.golemoverhaul$owner;
    }

    @Override
    public void golemoverhaul$setOwner(UUID owner) {
        this.golemoverhaul$owner = owner;
    }

    @Override
    public boolean golemoverhaul$hasGolemHive() {
        return this.golemoverhaul$owner != null;
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void golemoverhaul$addAdditionalSaveData(CompoundTag compound, CallbackInfo ci) {
        if (this.golemoverhaul$owner != null) {
            compound.putUUID("HoneyGolemOwner", this.golemoverhaul$owner);
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void golemoverhaul$readAdditionalSaveData(CompoundTag compound, CallbackInfo ci) {
        if (compound.contains("HoneyGolemOwner")) {
            this.golemoverhaul$owner = compound.getUUID("HoneyGolemOwner");
        }
    }

    @Inject(method={"wantsToEnterHive"}, at={@At(value="HEAD")}, cancellable=true)
    private void golemoverhaul$wantsToEnterHive(CallbackInfoReturnable<Boolean> cir) {
        ServerLevel level;
        Entity entity;
        Level level2;
        if (this.golemoverhaul$owner != null && (level2 = this.level()) instanceof ServerLevel && (entity = (level = (ServerLevel)level2).getEntity(this.golemoverhaul$owner)) instanceof HoneyGolem) {
            HoneyGolem golem = (HoneyGolem)entity;
            if (golem.getTarget() != null) {
                cir.setReturnValue((Object)false);
                return;
            }
            if (level.isNight()) {
                cir.setReturnValue((Object)true);
            }
        }
    }
}

