/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamresourceful.bytecodecs.base.ByteCodec;
import com.teamresourceful.bytecodecs.base.ObjectEntryByteCodec;
import com.teamresourceful.bytecodecs.base.object.ObjectByteCodec;
import com.teamresourceful.resourcefullib.common.bytecodecs.ExtraByteCodecs;
import com.teamresourceful.resourcefullib.common.recipe.CodecRecipe;
import com.teamresourceful.resourcefullib.common.recipe.CodecRecipeSerializer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import org.jetbrains.annotations.NotNull;
import tech.alexnijjar.golemoverhaul.common.recipes.SingleEntityInput;
import tech.alexnijjar.golemoverhaul.common.registry.ModRecipeSerializers;
import tech.alexnijjar.golemoverhaul.common.registry.ModRecipeTypes;

public record GolemConstructionRecipe(List<String> pattern, Map<String, ResourceKey<Block>> key, ResourceKey<EntityType<?>> entity, ResourceKey<Item> item, boolean visualOnly, float blockScale, float entityScale) implements CodecRecipe<SingleEntityInput>
{
    public static final MapCodec<GolemConstructionRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.listOf().fieldOf("pattern").forGetter(GolemConstructionRecipe::pattern), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)ResourceKey.codec((ResourceKey)Registries.BLOCK)).fieldOf("key").forGetter(GolemConstructionRecipe::key), (App)ResourceKey.codec((ResourceKey)Registries.ENTITY_TYPE).fieldOf("entity").forGetter(GolemConstructionRecipe::entity), (App)ResourceKey.codec((ResourceKey)Registries.ITEM).fieldOf("item").forGetter(GolemConstructionRecipe::item), (App)Codec.BOOL.optionalFieldOf("visualOnly", (Object)false).forGetter(GolemConstructionRecipe::visualOnly), (App)Codec.FLOAT.optionalFieldOf("blockScale", (Object)Float.valueOf(1.0f)).forGetter(GolemConstructionRecipe::blockScale), (App)Codec.FLOAT.optionalFieldOf("entityScale", (Object)Float.valueOf(1.0f)).forGetter(GolemConstructionRecipe::entityScale)).apply((Applicative)instance, GolemConstructionRecipe::new));
    public static final ByteCodec<GolemConstructionRecipe> NETWORK_CODEC = ObjectByteCodec.create((ObjectEntryByteCodec)ByteCodec.STRING.listOf().fieldOf(GolemConstructionRecipe::pattern), (ObjectEntryByteCodec)new com.teamresourceful.bytecodecs.defaults.MapCodec(ByteCodec.STRING, ExtraByteCodecs.resourceKey((ResourceKey)Registries.BLOCK)).fieldOf(GolemConstructionRecipe::key), (ObjectEntryByteCodec)ExtraByteCodecs.resourceKey((ResourceKey)Registries.ENTITY_TYPE).fieldOf(GolemConstructionRecipe::entity), (ObjectEntryByteCodec)ExtraByteCodecs.resourceKey((ResourceKey)Registries.ITEM).fieldOf(GolemConstructionRecipe::item), (ObjectEntryByteCodec)ByteCodec.BOOLEAN.fieldOf(GolemConstructionRecipe::visualOnly), (ObjectEntryByteCodec)ByteCodec.FLOAT.fieldOf(GolemConstructionRecipe::blockScale), (ObjectEntryByteCodec)ByteCodec.FLOAT.fieldOf(GolemConstructionRecipe::entityScale), GolemConstructionRecipe::new);

    public boolean matches(SingleEntityInput input, Level level) {
        Optional key = BuiltInRegistries.ENTITY_TYPE.getResourceKey(input.entity());
        return key.isPresent() && ((ResourceKey)key.get()).equals(this.entity());
    }

    public CodecRecipeSerializer<? extends CodecRecipe<SingleEntityInput>> serializer() {
        return (CodecRecipeSerializer)ModRecipeSerializers.GOLEM_CONSTRUCTION.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)ModRecipeTypes.GOLEM_CONSTRUCTION.get();
    }

    public BlockPattern createPattern() {
        BlockPatternBuilder builder = BlockPatternBuilder.start();
        builder.aisle(this.pattern.toArray(new String[0]));
        this.key.forEach((key, block_key) -> builder.where(key.charAt(0), BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)Objects.requireNonNull((Block)BuiltInRegistries.BLOCK.get(block_key))))));
        return builder.build();
    }
}

