/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.client.renderers.entities.golems;

import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.Entity;
import tech.alexnijjar.golemoverhaul.client.renderers.entities.golems.base.BaseGolemModel;
import tech.alexnijjar.golemoverhaul.client.renderers.entities.golems.base.BaseGolemRenderer;
import tech.alexnijjar.golemoverhaul.common.entities.golems.HoneyGolem;
import tech.alexnijjar.golemoverhaul.common.registry.ModEntityTypes;

public class HoneyGolemRenderer
extends BaseGolemRenderer<HoneyGolem> {
    public static final ResourceLocation FULL_TEXTURE_1 = ResourceLocation.fromNamespaceAndPath((String)"golemoverhaul", (String)"textures/entity/honey/honey_golem_full_1.png");
    public static final ResourceLocation FULL_TEXTURE_2 = ResourceLocation.fromNamespaceAndPath((String)"golemoverhaul", (String)"textures/entity/honey/honey_golem_full_2.png");
    public static final ResourceLocation FULL_TEXTURE_3 = ResourceLocation.fromNamespaceAndPath((String)"golemoverhaul", (String)"textures/entity/honey/honey_golem_full_3.png");

    public HoneyGolemRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, new BaseGolemModel<HoneyGolem>(ModEntityTypes.HONEY_GOLEM, true, 20));
    }

    public ResourceLocation getTextureLocation(HoneyGolem golem) {
        if (!golem.isFullOfHoney()) {
            return super.getTextureLocation((Entity)golem);
        }
        return switch (golem.getCrackiness()) {
            default -> throw new MatchException(null, null);
            case Crackiness.Level.NONE, Crackiness.Level.LOW -> FULL_TEXTURE_1;
            case Crackiness.Level.MEDIUM -> FULL_TEXTURE_2;
            case Crackiness.Level.HIGH -> FULL_TEXTURE_3;
        };
    }
}

