/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.client;

import com.teamresourceful.resourcefullib.common.network.Packet;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import tech.alexnijjar.golemoverhaul.client.renderers.entities.golems.BarrelGolemRenderer;
import tech.alexnijjar.golemoverhaul.client.renderers.entities.golems.CandleGolemRenderer;
import tech.alexnijjar.golemoverhaul.client.renderers.entities.golems.CoalGolemRenderer;
import tech.alexnijjar.golemoverhaul.client.renderers.entities.golems.HayGolemRenderer;
import tech.alexnijjar.golemoverhaul.client.renderers.entities.golems.HoneyGolemRenderer;
import tech.alexnijjar.golemoverhaul.client.renderers.entities.golems.KelpGolemRenderer;
import tech.alexnijjar.golemoverhaul.client.renderers.entities.golems.NetheriteGolemRenderer;
import tech.alexnijjar.golemoverhaul.client.renderers.entities.golems.SlimeGolemRenderer;
import tech.alexnijjar.golemoverhaul.client.renderers.entities.golems.TerracottaGolemRenderer;
import tech.alexnijjar.golemoverhaul.client.renderers.entities.projectiles.CandleFlameProjectileRenderer;
import tech.alexnijjar.golemoverhaul.client.renderers.entities.projectiles.HoneyBlobProjectileRenderer;
import tech.alexnijjar.golemoverhaul.common.constants.ConstantComponents;
import tech.alexnijjar.golemoverhaul.common.entities.golems.NetheriteGolem;
import tech.alexnijjar.golemoverhaul.common.network.NetworkHandler;
import tech.alexnijjar.golemoverhaul.common.network.packets.ServerboundGolemSummonPacket;
import tech.alexnijjar.golemoverhaul.common.registry.ModEntityTypes;

@EventBusSubscriber(value={Dist.CLIENT}, modid="golemoverhaul", bus=EventBusSubscriber.Bus.MOD)
public class GolemOverhaulClient {
    public static final KeyMapping KEY_NETHERITE_GOLEM_SUMMON = new KeyMapping(ConstantComponents.NETHERITE_GOLEM_SUMMON_KEY.getString(), 82, ConstantComponents.GOLEM_OVERHAUL_CATEGORY.getString());

    @SubscribeEvent
    private static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)ModEntityTypes.BARREL_GOLEM.get(), BarrelGolemRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.CANDLE_GOLEM.get(), CandleGolemRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.COAL_GOLEM.get(), CoalGolemRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.HAY_GOLEM.get(), HayGolemRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.HONEY_GOLEM.get(), HoneyGolemRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.KELP_GOLEM.get(), KelpGolemRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.NETHERITE_GOLEM.get(), NetheriteGolemRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.SLIME_GOLEM.get(), SlimeGolemRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.TERRACOTTA_GOLEM.get(), TerracottaGolemRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.CANDLE_FLAME.get(), CandleFlameProjectileRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.MUD_BALL.get(), context -> new GeoEntityRenderer(context, (GeoModel)new DefaultedEntityGeoModel(BuiltInRegistries.ENTITY_TYPE.getKey((Object)((EntityType)ModEntityTypes.MUD_BALL.get())))));
        event.registerEntityRenderer((EntityType)ModEntityTypes.HONEY_BLOB.get(), HoneyBlobProjectileRenderer::new);
    }

    public static void onClientTick(ClientTickEvent.Pre event) {
        if (KEY_NETHERITE_GOLEM_SUMMON.consumeClick()) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player == null) {
                return;
            }
            if (player.getVehicle() instanceof NetheriteGolem) {
                NetworkHandler.CHANNEL.sendToServer((Packet)new ServerboundGolemSummonPacket());
            }
        }
    }

    @SubscribeEvent
    public static void onRegisterKeyBindings(RegisterKeyMappingsEvent event) {
        event.register(KEY_NETHERITE_GOLEM_SUMMON);
    }
}

