/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.registry.variant;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.condition.AllOfCondition;
import com.stevekung.fishofthieves.entity.condition.AnyOfCondition;
import com.stevekung.fishofthieves.entity.condition.ContinentalnessCondition;
import com.stevekung.fishofthieves.entity.condition.MatchBiomeCondition;
import com.stevekung.fishofthieves.entity.condition.MatchMinimumBlocksInRangeCondition;
import com.stevekung.fishofthieves.entity.condition.NightCondition;
import com.stevekung.fishofthieves.entity.condition.ProbabilityCondition;
import com.stevekung.fishofthieves.entity.condition.SeeSkyCondition;
import com.stevekung.fishofthieves.entity.condition.SpawnCondition;
import com.stevekung.fishofthieves.entity.variant.AbstractFishVariant;
import com.stevekung.fishofthieves.entity.variant.WildsplashVariant;
import com.stevekung.fishofthieves.registry.FOTBiomes;
import com.stevekung.fishofthieves.registry.FOTRegistries;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.utils.Continentalness;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;

public class WildsplashVariants {
    public static final ResourceKey<WildsplashVariant> RUSSET = WildsplashVariants.createKey("russet");
    public static final ResourceKey<WildsplashVariant> SANDY = WildsplashVariants.createKey("sandy");
    public static final ResourceKey<WildsplashVariant> OCEAN = WildsplashVariants.createKey("ocean");
    public static final ResourceKey<WildsplashVariant> MUDDY = WildsplashVariants.createKey("muddy");
    public static final ResourceKey<WildsplashVariant> CORAL = WildsplashVariants.createKey("coral");

    public static void bootstrap(BootstrapContext<WildsplashVariant> context) {
        AbstractFishVariant.RegisterContext<WildsplashVariant> registerContext = AbstractFishVariant.RegisterContext.create("wildsplash", WildsplashVariant::new);
        HolderGetter biomeLookup = context.lookup(Registries.BIOME);
        registerContext.register(context, RUSSET, "russet", 0, new SpawnCondition[0]);
        registerContext.register(context, SANDY, "sandy", 1, AnyOfCondition.anyOf(MatchBiomeCondition.biomes((HolderSet<Biome>)biomeLookup.getOrThrow(BiomeTags.IS_BEACH)).and(ContinentalnessCondition.builder().continentalness(Continentalness.COAST)), MatchBiomeCondition.biomes((HolderSet<Biome>)HolderSet.direct((Holder[])new Holder[]{biomeLookup.getOrThrow(FOTBiomes.TROPICAL_ISLAND)}))).build());
        registerContext.register(context, OCEAN, "ocean", 2, MatchBiomeCondition.biomes((HolderSet<Biome>)biomeLookup.getOrThrow(BiomeTags.IS_OCEAN)).build());
        registerContext.register(context, MUDDY, "muddy", 3, AllOfCondition.allOf(ProbabilityCondition.defaultRareProbablity(), MatchBiomeCondition.biomes((HolderSet<Biome>)biomeLookup.getOrThrow(BiomeTags.HAS_CLOSER_WATER_FOG))).build());
        registerContext.register(context, CORAL, "coral", 4, true, AllOfCondition.allOf(NightCondition.night(), SeeSkyCondition.seeSky(), MatchBiomeCondition.biomes((HolderSet<Biome>)HolderSet.direct((Holder[])new Holder[]{biomeLookup.getOrThrow(Biomes.WARM_OCEAN)})), MatchMinimumBlocksInRangeCondition.minimumBlocksInRange(Optional.of(context.lookup(Registries.BLOCK).getOrThrow(FOTTags.Blocks.CORAL_WILDSPLASH_SPAWNABLE_ON)), Optional.empty(), 4, 24)).build());
    }

    public static void bootstrapSimple(BootstrapContext<WildsplashVariant> context) {
        AbstractFishVariant.RegisterContext<WildsplashVariant> registerContext = AbstractFishVariant.RegisterContext.create("wildsplash", WildsplashVariant::new);
        registerContext.register(context, RUSSET, "russet", 0, new SpawnCondition[0]);
        registerContext.register(context, SANDY, "sandy", 1, new SpawnCondition[0]);
        registerContext.register(context, OCEAN, "ocean", 2, new SpawnCondition[0]);
        registerContext.register(context, MUDDY, "muddy", 3, ProbabilityCondition.defaultRareProbablity().build());
        registerContext.register(context, CORAL, "coral", 4, true, AllOfCondition.allOf(NightCondition.night(), SeeSkyCondition.seeSky()).build());
    }

    private static ResourceKey<WildsplashVariant> createKey(String name) {
        return ResourceKey.create(FOTRegistries.WILDSPLASH_VARIANT, (ResourceLocation)FishOfThieves.id(name));
    }
}

