/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.registry.variant;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.condition.AllOfCondition;
import com.stevekung.fishofthieves.entity.condition.AnyOfCondition;
import com.stevekung.fishofthieves.entity.condition.ContinentalnessCondition;
import com.stevekung.fishofthieves.entity.condition.MatchBiomeCondition;
import com.stevekung.fishofthieves.entity.condition.NightCondition;
import com.stevekung.fishofthieves.entity.condition.ProbabilityCondition;
import com.stevekung.fishofthieves.entity.condition.SeeSkyCondition;
import com.stevekung.fishofthieves.entity.condition.SkyBrightnessCondition;
import com.stevekung.fishofthieves.entity.condition.SkyDarkenCondition;
import com.stevekung.fishofthieves.entity.condition.SpawnCondition;
import com.stevekung.fishofthieves.entity.variant.AbstractFishVariant;
import com.stevekung.fishofthieves.entity.variant.StormfishVariant;
import com.stevekung.fishofthieves.registry.FOTBiomes;
import com.stevekung.fishofthieves.registry.FOTRegistries;
import com.stevekung.fishofthieves.utils.Continentalness;
import java.util.List;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;

public class StormfishVariants {
    public static final ResourceKey<StormfishVariant> ANCIENT = StormfishVariants.createKey("ancient");
    public static final ResourceKey<StormfishVariant> SHORES = StormfishVariants.createKey("shores");
    public static final ResourceKey<StormfishVariant> WILD = StormfishVariants.createKey("wild");
    public static final ResourceKey<StormfishVariant> SHADOW = StormfishVariants.createKey("shadow");
    public static final ResourceKey<StormfishVariant> TWILIGHT = StormfishVariants.createKey("twilight");

    public static void bootstrap(BootstrapContext<StormfishVariant> context) {
        AbstractFishVariant.RegisterContext<StormfishVariant> registerContext = AbstractFishVariant.RegisterContext.create("stormfish", StormfishVariant::new);
        HolderGetter biomeLookup = context.lookup(Registries.BIOME);
        registerContext.register(context, ANCIENT, "ancient", 0, new SpawnCondition[0]);
        registerContext.register(context, SHORES, "shores", 1, ContinentalnessCondition.builder().continentalness(Continentalness.COAST).build());
        registerContext.register(context, WILD, "wild", 2, AnyOfCondition.anyOf(MatchBiomeCondition.biomes((HolderSet<Biome>)HolderSet.direct((Holder[])new Holder[]{biomeLookup.getOrThrow(Biomes.SPARSE_JUNGLE)})), MatchBiomeCondition.biomes((HolderSet<Biome>)HolderSet.direct((Holder[])new Holder[]{biomeLookup.getOrThrow(FOTBiomes.TROPICAL_ISLAND)}))).build());
        registerContext.register(context, SHADOW, "shadow", 3, List.of(AllOfCondition.allOf(ProbabilityCondition.defaultRareProbablity(), SkyBrightnessCondition.skyBrightness(MinMaxBounds.Ints.atMost((int)4))).build()), List.of(ProbabilityCondition.defaultRareProbablity().build()));
        registerContext.register(context, TWILIGHT, "twilight", 4, true, SkyDarkenCondition.skyDarken(MinMaxBounds.Ints.between((int)9, (int)16)).build());
    }

    public static void bootstrapSimple(BootstrapContext<StormfishVariant> context) {
        AbstractFishVariant.RegisterContext<StormfishVariant> registerContext = AbstractFishVariant.RegisterContext.create("stormfish", StormfishVariant::new);
        registerContext.register(context, ANCIENT, "ancient", 0, new SpawnCondition[0]);
        registerContext.register(context, SHORES, "shores", 1, new SpawnCondition[0]);
        registerContext.register(context, WILD, "wild", 2, new SpawnCondition[0]);
        registerContext.register(context, SHADOW, "shadow", 3, ProbabilityCondition.defaultRareProbablity().build());
        registerContext.register(context, TWILIGHT, "twilight", 4, true, AllOfCondition.allOf(NightCondition.night(), SeeSkyCondition.seeSky()).build());
    }

    private static ResourceKey<StormfishVariant> createKey(String name) {
        return ResourceKey.create(FOTRegistries.STORMFISH_VARIANT, (ResourceLocation)FishOfThieves.id(name));
    }
}

