/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.registry.variant;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.condition.AllOfCondition;
import com.stevekung.fishofthieves.entity.condition.AnyOfCondition;
import com.stevekung.fishofthieves.entity.condition.MatchStructureCondition;
import com.stevekung.fishofthieves.entity.condition.NightCondition;
import com.stevekung.fishofthieves.entity.condition.ProbabilityCondition;
import com.stevekung.fishofthieves.entity.condition.RainingCondition;
import com.stevekung.fishofthieves.entity.condition.RandomChanceCondition;
import com.stevekung.fishofthieves.entity.condition.SeeSkyCondition;
import com.stevekung.fishofthieves.entity.condition.SpawnCondition;
import com.stevekung.fishofthieves.entity.condition.TimeOfDayCondition;
import com.stevekung.fishofthieves.entity.variant.AbstractFishVariant;
import com.stevekung.fishofthieves.entity.variant.PlentifinVariant;
import com.stevekung.fishofthieves.registry.FOTRegistries;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.StructureTags;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;

public class PlentifinVariants {
    public static final ResourceKey<PlentifinVariant> OLIVE = PlentifinVariants.createKey("olive");
    public static final ResourceKey<PlentifinVariant> AMBER = PlentifinVariants.createKey("amber");
    public static final ResourceKey<PlentifinVariant> CLOUDY = PlentifinVariants.createKey("cloudy");
    public static final ResourceKey<PlentifinVariant> BONEDUST = PlentifinVariants.createKey("bonedust");
    public static final ResourceKey<PlentifinVariant> WATERY = PlentifinVariants.createKey("watery");

    public static void bootstrap(BootstrapContext<PlentifinVariant> context) {
        HolderGetter structureLookup = context.lookup(Registries.STRUCTURE);
        AbstractFishVariant.RegisterContext<PlentifinVariant> registerContext = AbstractFishVariant.RegisterContext.create("plentifin", PlentifinVariant::new);
        registerContext.register(context, OLIVE, "olive", 0, new SpawnCondition[0]);
        registerContext.register(context, AMBER, "amber", 1, RainingCondition.raining().invert().and(TimeOfDayCondition.timeOfDay(MinMaxBounds.Doubles.between((double)0.75, (double)0.9))).and(SeeSkyCondition.seeSky()).build());
        registerContext.register(context, CLOUDY, "cloudy", 2, AllOfCondition.allOf(RainingCondition.raining(), SeeSkyCondition.seeSky()).build());
        registerContext.register(context, BONEDUST, "bonedust", 3, AnyOfCondition.anyOf(ProbabilityCondition.defaultRareProbablity(), RandomChanceCondition.chance(10).and(MatchStructureCondition.structures((HolderSet<Structure>)HolderSet.direct((Holder[])new Holder[]{structureLookup.getOrThrow(BuiltinStructures.STRONGHOLD)})).or(MatchStructureCondition.structures((HolderSet<Structure>)structureLookup.getOrThrow(StructureTags.MINESHAFT))))).build());
        registerContext.register(context, WATERY, "watery", 4, true, AllOfCondition.allOf(NightCondition.night(), SeeSkyCondition.seeSky()).build());
    }

    public static void bootstrapSimple(BootstrapContext<PlentifinVariant> context) {
        AbstractFishVariant.RegisterContext<PlentifinVariant> registerContext = AbstractFishVariant.RegisterContext.create("plentifin", PlentifinVariant::new);
        registerContext.register(context, OLIVE, "olive", 0, new SpawnCondition[0]);
        registerContext.register(context, AMBER, "amber", 1, new SpawnCondition[0]);
        registerContext.register(context, CLOUDY, "cloudy", 2, new SpawnCondition[0]);
        registerContext.register(context, BONEDUST, "bonedust", 3, ProbabilityCondition.defaultRareProbablity().build());
        registerContext.register(context, WATERY, "watery", 4, true, AllOfCondition.allOf(NightCondition.night(), SeeSkyCondition.seeSky()).build());
    }

    private static ResourceKey<PlentifinVariant> createKey(String name) {
        return ResourceKey.create(FOTRegistries.PLENTIFIN_VARIANT, (ResourceLocation)FishOfThieves.id(name));
    }
}

