/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.registry;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.block.HangingMangoFruitBlock;
import com.stevekung.fishofthieves.block.MangoFruitBlock;
import com.stevekung.fishofthieves.block.PineappleCropBlock;
import com.stevekung.fishofthieves.block.PomegranatePlantBlock;
import com.stevekung.fishofthieves.feature.FishBoneFeature;
import com.stevekung.fishofthieves.feature.SimpleAgeBlockFeature;
import com.stevekung.fishofthieves.feature.SingleBlockFeature;
import com.stevekung.fishofthieves.feature.TropicalIslandBlockBlobFeature;
import com.stevekung.fishofthieves.feature.blockpredicates.BlockBrightnessPredicate;
import com.stevekung.fishofthieves.feature.blockpredicates.SeeSkyPredicate;
import com.stevekung.fishofthieves.feature.configurations.SimpleAgeBlockConfiguration;
import com.stevekung.fishofthieves.feature.foliageplacers.BananaLeavesPlacer;
import com.stevekung.fishofthieves.feature.foliageplacers.CoconutFrondsPlacer;
import com.stevekung.fishofthieves.feature.stateproviders.DirectionalRandomizedIntBooleanStateProvider;
import com.stevekung.fishofthieves.feature.stateproviders.RandomizedIntBooleanStateProvider;
import com.stevekung.fishofthieves.feature.treedecorators.BananaDecorator;
import com.stevekung.fishofthieves.feature.treedecorators.BananaShootsDecorator;
import com.stevekung.fishofthieves.feature.treedecorators.CoconutDecorator;
import com.stevekung.fishofthieves.feature.treedecorators.DirectionalAttachedToLeavesDecorator;
import com.stevekung.fishofthieves.feature.trunkplacers.BananaTrunkPlacer;
import com.stevekung.fishofthieves.feature.trunkplacers.CoconutTrunkPlacer;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTPlacements;
import java.util.List;
import java.util.OptionalInt;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.TreePlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleRandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.ThreeLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FancyFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.RandomizedIntStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.AttachedToLeavesDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.BeehiveDecorator;
import net.minecraft.world.level.levelgen.feature.trunkplacers.FancyTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;

public class FOTFeatures {
    private static final FishBoneFeature FISH_BONE_FEATURE = FOTFeatures.register("fish_bone", new FishBoneFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.CODEC));
    private static final SimpleAgeBlockFeature SIMPLE_AGE_BLOCK = FOTFeatures.register("simple_age_block", new SimpleAgeBlockFeature(SimpleAgeBlockConfiguration.CODEC));
    private static final SingleBlockFeature SINGLE_BLOCK = FOTFeatures.register("single_block", new SingleBlockFeature((Codec<SimpleBlockConfiguration>)SimpleBlockConfiguration.CODEC));
    private static final TropicalIslandBlockBlobFeature TROPICAL_ISLAND_BLOB = FOTFeatures.register("tropical_island_blob", new TropicalIslandBlockBlobFeature((Codec<BlockStateConfiguration>)BlockStateConfiguration.CODEC));
    public static final ResourceKey<ConfiguredFeature<?, ?>> FISH_BONE = FOTFeatures.createKey("fish_bone");
    public static final ResourceKey<ConfiguredFeature<?, ?>> COCONUT_TREE = FOTFeatures.createKey("coconut_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BANANA_TREE = FOTFeatures.createKey("banana_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MANGO_TREE = FOTFeatures.createKey("mango_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MANGO_TREE_BEES_02 = FOTFeatures.createKey("mango_tree_bees_02");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TROPICAL_FLOWER = FOTFeatures.createKey("tropical_flower");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TREES_TROPICAL_ISLAND = FOTFeatures.createKey("trees_tropical_island");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WILD_PINEAPPLE = FOTFeatures.createKey("wild_pineapple");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TALL_WILD_PINEAPPLE = FOTFeatures.createKey("tall_wild_pineapple");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_WILD_PINEAPPLE = FOTFeatures.createKey("patch_wild_pineapple");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_TROPICAL_MELON = FOTFeatures.createKey("patch_tropical_melon");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TREES_COCONUT = FOTFeatures.createKey("trees_coconut");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WILD_POMEGRANATE = FOTFeatures.createKey("wild_pomegranate");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TALL_WILD_POMEGRANATE = FOTFeatures.createKey("tall_wild_pomegranate");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_WILD_POMEGRANATE = FOTFeatures.createKey("patch_wild_pomegranate");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_TROPICAL_BUSH = FOTFeatures.createKey("patch_tropical_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TROPICAL_ISLAND_ROCK = FOTFeatures.createKey("tropical_island_rock");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPARSE_JUNGLE_FRUIT_TREES = FOTFeatures.createKey("sparse_jungle_fruit_trees");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPARSE_JUNGLE_PATCH_WILD_PINEAPPLE = FOTFeatures.createKey("sparse_jungle_patch_wild_pineapple");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPARSE_JUNGLE_PATCH_WILD_POMEGRANATE = FOTFeatures.createKey("sparse_jungle_patch_wild_pomegranate");

    public static void init() {
        FishOfThieves.LOGGER.info("Registering Feature");
    }

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        HolderGetter placedFeature = context.lookup(Registries.PLACED_FEATURE);
        FeatureUtils.register(context, FISH_BONE, (Feature)FISH_BONE_FEATURE, (FeatureConfiguration)NoneFeatureConfiguration.INSTANCE);
        FeatureUtils.register(context, COCONUT_TREE, (Feature)Feature.TREE, (FeatureConfiguration)FOTFeatures.createCoconutTree().decorators((List)ImmutableList.of((Object)((Object)new CoconutDecorator(0.6f, 0.45f, 2)))).dirt((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.SAND)).ignoreVines().build());
        FeatureUtils.register(context, BANANA_TREE, (Feature)Feature.TREE, (FeatureConfiguration)FOTFeatures.createBananaTree().decorators((List)ImmutableList.of((Object)((Object)new BananaDecorator(0.4f, 0.2f, 0.4f, 6)), (Object)((Object)new BananaShootsDecorator(0.3f)))).dirt((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.DIRT)).ignoreVines().build());
        FeatureUtils.register(context, MANGO_TREE, (Feature)Feature.TREE, (FeatureConfiguration)FOTFeatures.createMangoTree(0.01f).build());
        FeatureUtils.register(context, MANGO_TREE_BEES_02, (Feature)Feature.TREE, (FeatureConfiguration)FOTFeatures.createMangoTree(0.2f).build());
        FeatureUtils.register(context, TREES_TROPICAL_ISLAND, (Feature)Feature.RANDOM_SELECTOR, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature((Holder)placedFeature.getOrThrow(TreePlacements.FANCY_OAK_CHECKED), 0.05f), new WeightedPlacedFeature((Holder)placedFeature.getOrThrow(FOTPlacements.MANGO_TREE_CHECKED), 0.1f), new WeightedPlacedFeature((Holder)placedFeature.getOrThrow(FOTPlacements.BANANA_TREE_CHECKED), 0.1f)), (Holder)placedFeature.getOrThrow(TreePlacements.JUNGLE_TREE_CHECKED)));
        FeatureUtils.register(context, TROPICAL_FLOWER, (Feature)Feature.FLOWER, (FeatureConfiguration)FOTFeatures.grassPatch((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)FOTBlocks.PINK_PLUMERIA.defaultBlockState(), 8).add((Object)FOTBlocks.LIGHT_BLUE_PLUMERIA.defaultBlockState(), 6).add((Object)FOTBlocks.WHITE_PLUMERIA.defaultBlockState(), 3)), 64));
        FeatureUtils.register(context, WILD_PINEAPPLE, (Feature)Feature.FLOWER, (FeatureConfiguration)FOTFeatures.wildPineapplePatch((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)((BlockState)FOTBlocks.PINEAPPLE_CROP.defaultBlockState().setValue((Property)PineappleCropBlock.AGE, (Comparable)Integer.valueOf(0))), 8).add((Object)((BlockState)FOTBlocks.PINEAPPLE_CROP.defaultBlockState().setValue((Property)PineappleCropBlock.AGE, (Comparable)Integer.valueOf(1))), 6).add((Object)((BlockState)FOTBlocks.PINEAPPLE_CROP.defaultBlockState().setValue((Property)PineappleCropBlock.AGE, (Comparable)Integer.valueOf(2))), 4).add((Object)((BlockState)FOTBlocks.PINEAPPLE_CROP.defaultBlockState().setValue((Property)PineappleCropBlock.AGE, (Comparable)Integer.valueOf(3))), 2)), 16));
        FeatureUtils.register(context, TALL_WILD_PINEAPPLE, (Feature)SIMPLE_AGE_BLOCK, (FeatureConfiguration)new SimpleAgeBlockConfiguration(new RandomizedIntStateProvider((BlockStateProvider)BlockStateProvider.simple((BlockState)FOTBlocks.PINEAPPLE_CROP.defaultBlockState()), PineappleCropBlock.AGE, (IntProvider)UniformInt.of((int)4, (int)5))));
        FeatureUtils.register(context, PATCH_WILD_PINEAPPLE, (Feature)Feature.RANDOM_SELECTOR, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature((Holder)placedFeature.getOrThrow(FOTPlacements.TALL_WILD_PINEAPPLE), 0.85f)), (Holder)placedFeature.getOrThrow(FOTPlacements.WILD_PINEAPPLE)));
        FeatureUtils.register(context, PATCH_TROPICAL_MELON, (Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)new RandomPatchConfiguration(16, 7, 3, PlacementUtils.filtered((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.MELON)), (BlockPredicate)BlockPredicate.allOf((BlockPredicate[])new BlockPredicate[]{BlockPredicate.replaceable(), BlockPredicate.noFluid(), BlockPredicate.matchesBlocks((Vec3i)Direction.DOWN.getNormal(), (Block[])new Block[]{Blocks.GRASS_BLOCK})}))));
        FeatureUtils.register(context, TREES_COCONUT, (Feature)Feature.SIMPLE_RANDOM_SELECTOR, (FeatureConfiguration)new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeature.getOrThrow(FOTPlacements.COCONUT_TREE_CHECKED)})));
        FeatureUtils.register(context, WILD_POMEGRANATE, (Feature)Feature.FLOWER, (FeatureConfiguration)FOTFeatures.wildPomegranatePatch((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)((BlockState)FOTBlocks.POMEGRANATE_PLANT.defaultBlockState().setValue((Property)PomegranatePlantBlock.AGE, (Comparable)Integer.valueOf(0))), 8).add((Object)((BlockState)FOTBlocks.POMEGRANATE_PLANT.defaultBlockState().setValue((Property)PomegranatePlantBlock.AGE, (Comparable)Integer.valueOf(1))), 6).add((Object)((BlockState)FOTBlocks.POMEGRANATE_PLANT.defaultBlockState().setValue((Property)PomegranatePlantBlock.AGE, (Comparable)Integer.valueOf(2))), 4).add((Object)((BlockState)FOTBlocks.POMEGRANATE_PLANT.defaultBlockState().setValue((Property)PomegranatePlantBlock.AGE, (Comparable)Integer.valueOf(3))), 2)), 16));
        FeatureUtils.register(context, TALL_WILD_POMEGRANATE, (Feature)SIMPLE_AGE_BLOCK, (FeatureConfiguration)new SimpleAgeBlockConfiguration(new RandomizedIntStateProvider((BlockStateProvider)BlockStateProvider.simple((BlockState)FOTBlocks.TALL_POMEGRANATE_PLANT.defaultBlockState()), PomegranatePlantBlock.AGE, (IntProvider)UniformInt.of((int)0, (int)3))));
        FeatureUtils.register(context, PATCH_WILD_POMEGRANATE, (Feature)Feature.RANDOM_SELECTOR, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature((Holder)placedFeature.getOrThrow(FOTPlacements.TALL_WILD_POMEGRANATE), 0.5f)), (Holder)placedFeature.getOrThrow(FOTPlacements.WILD_POMEGRANATE)));
        FeatureUtils.register(context, PATCH_TROPICAL_BUSH, (Feature)Feature.FLOWER, (FeatureConfiguration)new RandomPatchConfiguration(32, 4, 2, PlacementUtils.filtered((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)FOTBlocks.TROPICAL_MONSTERA.defaultBlockState(), 4).add((Object)FOTBlocks.TROPICAL_RED_FERN.defaultBlockState(), 2).add((Object)FOTBlocks.VERTICAL_BANANA_LEAVES.defaultBlockState(), 1))), (BlockPredicate)BlockPredicate.allOf((BlockPredicate[])new BlockPredicate[]{BlockPredicate.replaceable(), BlockPredicate.not((BlockPredicate)BlockBrightnessPredicate.value(13)), BlockPredicate.not((BlockPredicate)SeeSkyPredicate.INSTANCE), BlockPredicate.matchesBlocks((Vec3i)Direction.DOWN.getNormal(), (Block[])new Block[]{Blocks.GRASS_BLOCK})}))));
        FeatureUtils.register(context, TROPICAL_ISLAND_ROCK, (Feature)TROPICAL_ISLAND_BLOB, (FeatureConfiguration)new BlockStateConfiguration(Blocks.STONE.defaultBlockState()));
        FeatureUtils.register(context, SPARSE_JUNGLE_FRUIT_TREES, (Feature)Feature.SIMPLE_RANDOM_SELECTOR, (FeatureConfiguration)new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeature.getOrThrow(FOTPlacements.MANGO_TREE_CHECKED), placedFeature.getOrThrow(FOTPlacements.BANANA_TREE_CHECKED)})));
        FeatureUtils.register(context, SPARSE_JUNGLE_PATCH_WILD_PINEAPPLE, (Feature)Feature.SIMPLE_RANDOM_SELECTOR, (FeatureConfiguration)new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeature.getOrThrow(FOTPlacements.TALL_WILD_PINEAPPLE), placedFeature.getOrThrow(FOTPlacements.WILD_PINEAPPLE)})));
        FeatureUtils.register(context, SPARSE_JUNGLE_PATCH_WILD_POMEGRANATE, (Feature)Feature.SIMPLE_RANDOM_SELECTOR, (FeatureConfiguration)new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeature.getOrThrow(FOTPlacements.TALL_WILD_POMEGRANATE), placedFeature.getOrThrow(FOTPlacements.WILD_POMEGRANATE)})));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createCoconutTree() {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)FOTBlocks.COCONUT_LOG), (TrunkPlacer)new CoconutTrunkPlacer(7, 2, 2, (BlockStateProvider)BlockStateProvider.simple((Block)FOTBlocks.SMALL_COCONUT_LOG), (BlockStateProvider)BlockStateProvider.simple((Block)FOTBlocks.MEDIUM_COCONUT_LOG), (BlockStateProvider)BlockStateProvider.simple((Block)FOTBlocks.SMALL_TOP_COCONUT_LOG)), (BlockStateProvider)BlockStateProvider.simple((Block)FOTBlocks.COCONUT_FRONDS), (FoliagePlacer)new CoconutFrondsPlacer(2, 1, List.of(Pair.of((Object)7, (Object)1))), (FeatureSize)new ThreeLayersFeatureSize(5, 15, 1, 2, 4, OptionalInt.empty()));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createBananaTree() {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)FOTBlocks.BANANA_STEM), (TrunkPlacer)new BananaTrunkPlacer(3, 6, (BlockStateProvider)BlockStateProvider.simple((Block)FOTBlocks.BANANA_CLUSTER_GROWABLE_STEM)), (BlockStateProvider)BlockStateProvider.simple((Block)FOTBlocks.BANANA_LEAVES), (FoliagePlacer)new BananaLeavesPlacer(0.2f), (FeatureSize)new ThreeLayersFeatureSize(5, 8, 1, 2, 5, OptionalInt.empty()));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createMangoTree(float beehiveChance) {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.OAK_LOG), (TrunkPlacer)new FancyTrunkPlacer(5, 11, 0), (BlockStateProvider)BlockStateProvider.simple((Block)FOTBlocks.MANGO_LEAVES), (FoliagePlacer)new FancyFoliagePlacer((IntProvider)ConstantInt.of((int)3), (IntProvider)ConstantInt.of((int)4), 4), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0, OptionalInt.of(4))).decorators(List.of(new AttachedToLeavesDecorator(0.1f, 2, 0, (BlockStateProvider)new RandomizedIntBooleanStateProvider((BlockStateProvider)BlockStateProvider.simple((BlockState)FOTBlocks.HANGING_MANGO_FRUIT.defaultBlockState()), HangingMangoFruitBlock.AGE, (IntProvider)UniformInt.of((int)0, (int)2), MangoFruitBlock.FALLING, ConstantFloat.of((float)0.6f)), 2, List.of(Direction.DOWN)), new DirectionalAttachedToLeavesDecorator(0.5f, 1, 1, new DirectionalRandomizedIntBooleanStateProvider((BlockStateProvider)BlockStateProvider.simple((BlockState)FOTBlocks.MANGO_FRUIT.defaultBlockState()), MangoFruitBlock.AGE, (IntProvider)UniformInt.of((int)0, (int)2), MangoFruitBlock.FACING, MangoFruitBlock.FALLING, ConstantFloat.of((float)0.6f)), 1, Direction.Plane.HORIZONTAL.stream().toList(), true), new BeehiveDecorator(beehiveChance))).ignoreVines();
    }

    private static RandomPatchConfiguration grassPatch(BlockStateProvider blockStateProvider, int tries) {
        return FeatureUtils.simpleRandomPatchConfiguration((int)tries, (Holder)PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration(blockStateProvider)));
    }

    private static RandomPatchConfiguration wildPineapplePatch(BlockStateProvider blockStateProvider, int tries) {
        return new RandomPatchConfiguration(tries, 4, 2, PlacementUtils.onlyWhenEmpty((Feature)SINGLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration(blockStateProvider)));
    }

    private static RandomPatchConfiguration wildPomegranatePatch(BlockStateProvider blockStateProvider, int tries) {
        return new RandomPatchConfiguration(tries, 5, 3, PlacementUtils.onlyWhenEmpty((Feature)SINGLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration(blockStateProvider)));
    }

    private static <C extends FeatureConfiguration, F extends Feature<C>> F register(String key, F feature) {
        return (F)((Feature)Registry.register((Registry)BuiltInRegistries.FEATURE, (ResourceLocation)FishOfThieves.id(key), feature));
    }

    private static ResourceKey<ConfiguredFeature<?, ?>> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)FishOfThieves.id(name));
    }
}

