/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.item;

import com.stevekung.fishofthieves.FishOfThieves;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;

public class FOTSpawnEggItem
extends SpawnEggItem {
    public FOTSpawnEggItem(EntityType<? extends Mob> defaultType, int backgroundColor, int highlightColor, Item.Properties properties) {
        super(defaultType, backgroundColor, highlightColor, properties);
    }

    public Component getName(ItemStack itemStack) {
        CustomData customData;
        MutableComponent name = super.getName(itemStack).copy();
        if (FishOfThieves.CONFIG.general.displayTrophySpawnEggInCreativeTab && !(customData = (CustomData)itemStack.getOrDefault(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY)).isEmpty() && customData.copyTag().getBoolean("Trophy")) {
            return name.append(" (").append((Component)Component.translatable((String)"entity.fishofthieves.trophy")).append(")");
        }
        return name;
    }

    public static void addTrophySpawnEgg(CreativeModeTab.Output output, Item item) {
        if (FishOfThieves.CONFIG.general.displayTrophySpawnEggInCreativeTab) {
            output.accept(FOTSpawnEggItem.create(item, false));
            output.accept(FOTSpawnEggItem.create(item, true));
        } else {
            output.accept((ItemLike)item);
        }
    }

    private static ItemStack create(Item item, boolean trophy) {
        ItemStack itemStack = new ItemStack((ItemLike)item);
        CustomData.update((DataComponentType)DataComponents.ENTITY_DATA, (ItemStack)itemStack, compoundTag -> {
            compoundTag.putString("id", BuiltInRegistries.ENTITY_TYPE.getKey((Object)((SpawnEggItem)item).getType(itemStack)).toString());
            compoundTag.putBoolean("Trophy", trophy);
        });
        return itemStack;
    }
}

