/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.feature.placement;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;

public abstract class AbstractNoiseRouterFilter
extends PlacementFilter {
    protected final FloatProvider floatProvider;

    public AbstractNoiseRouterFilter(FloatProvider floatProvider) {
        this.floatProvider = floatProvider;
    }

    protected boolean shouldPlace(PlacementContext context, RandomSource random, BlockPos pos) {
        ServerChunkCache serverChunkCache = context.getLevel().getLevel().getChunkSource();
        RandomState randomState = serverChunkCache.randomState();
        DensityFunction.SinglePointContext singlePointContext = new DensityFunction.SinglePointContext(pos.getX(), pos.getY(), pos.getZ());
        double densityFunction = this.getDensityFunction(randomState.router()).compute((DensityFunction.FunctionContext)singlePointContext);
        return densityFunction >= (double)this.floatProvider.getMinValue() && densityFunction <= (double)this.floatProvider.getMaxValue();
    }

    protected abstract DensityFunction getDensityFunction(NoiseRouter var1);
}

