/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.feature.foliageplacers;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.block.BananaLeavesBlock;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTFoliagePlacerTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class BananaLeavesPlacer
extends FoliagePlacer {
    public static final MapCodec<BananaLeavesPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> BananaLeavesPlacer.frondsPart(instance).apply((Applicative)instance, BananaLeavesPlacer::new));
    protected final float oneLeavesChance;

    protected static <P extends BananaLeavesPlacer> Products.P1<RecordCodecBuilder.Mu<P>, Float> frondsPart(RecordCodecBuilder.Instance<P> instance) {
        return instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("one_leaves_chance").forGetter(placer -> Float.valueOf(placer.oneLeavesChance)));
    }

    public BananaLeavesPlacer(float oneLeavesChance) {
        super((IntProvider)ConstantInt.of((int)0), (IntProvider)ConstantInt.of((int)0));
        this.oneLeavesChance = oneLeavesChance;
    }

    protected FoliagePlacerType<?> type() {
        return FOTFoliagePlacerTypes.BANANA_LEAVES_PLACER;
    }

    protected void createFoliage(LevelSimulatedReader level, FoliagePlacer.FoliageSetter blockSetter, RandomSource random, TreeConfiguration config, int maxFreeTreeHeight, FoliagePlacer.FoliageAttachment attachment, int foliageHeight, int foliageRadius, int offset) {
        BlockPos pos = attachment.pos();
        if (TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)pos)) {
            for (int localY = offset; localY >= offset - 1; --localY) {
                if (localY == 0) {
                    BlockState blockState = FOTBlocks.VERTICAL_BANANA_LEAVES.defaultBlockState();
                    if (blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                        blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(level.isFluidAtPosition(pos, fluidState -> fluidState.isSourceOfType((Fluid)Fluids.WATER))));
                    }
                    blockSetter.set(pos, blockState);
                    continue;
                }
                BlockPos.MutableBlockPos mutableBlockPos = pos.mutable();
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    Direction direction2 = direction.getOpposite();
                    BlockPos blockPos2 = mutableBlockPos.offset(direction2.getStepX(), localY, direction2.getStepZ());
                    BlockState blockState = (BlockState)((BlockState)((BlockState)config.foliageProvider.getState(random, pos).setValue((Property)BananaLeavesBlock.FACING, (Comparable)direction2)).setValue((Property)BananaLeavesBlock.COUNT, (Comparable)Integer.valueOf(random.nextFloat() < this.oneLeavesChance ? 1 : 2))).setValue(BananaLeavesBlock.TYPE, (Comparable)((Object)BananaLeavesBlock.Type.UPPER));
                    if (blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                        blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(level.isFluidAtPosition(pos, fluidState -> fluidState.isSourceOfType((Fluid)Fluids.WATER))));
                    }
                    if (!TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)blockPos2)) continue;
                    blockSetter.set(blockPos2, blockState);
                    blockSetter.set(blockPos2.relative(direction2, 1), (BlockState)blockState.setValue(BananaLeavesBlock.PART, (Comparable)((Object)BananaLeavesBlock.Part.TAIL)));
                }
            }
        }
    }

    public int foliageHeight(RandomSource random, int height, TreeConfiguration config) {
        return 1;
    }

    protected boolean shouldSkipLocation(RandomSource random, int localX, int localY, int localZ, int range, boolean large) {
        return localX == range && localZ == range && (random.nextInt(2) == 0 || localY == 0);
    }
}

