/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.entity.condition.SpawnCondition;
import com.stevekung.fishofthieves.entity.condition.SpawnConditionContext;
import com.stevekung.fishofthieves.entity.condition.SpawnConditionType;
import com.stevekung.fishofthieves.registry.FOTSpawnConditions;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.world.level.LightLayer;

public record SkyBrightnessCondition(MinMaxBounds.Ints brightness) implements SpawnCondition
{
    public static final MapCodec<SkyBrightnessCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MinMaxBounds.Ints.CODEC.fieldOf("brightness").forGetter(SkyBrightnessCondition::brightness)).apply((Applicative)instance, SkyBrightnessCondition::new));

    @Override
    public SpawnConditionType getType() {
        return FOTSpawnConditions.SKY_BRIGHTNESS;
    }

    @Override
    public boolean test(SpawnConditionContext context) {
        return this.brightness.matches(context.level().getBrightness(LightLayer.SKY, context.blockPos()));
    }

    public static SpawnCondition.Builder skyBrightness(MinMaxBounds.Ints brightness) {
        return () -> new SkyBrightnessCondition(brightness);
    }
}

