/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.entity.condition.SpawnCondition;
import com.stevekung.fishofthieves.entity.condition.SpawnConditionContext;
import com.stevekung.fishofthieves.entity.condition.SpawnConditionType;
import com.stevekung.fishofthieves.registry.FOTSpawnConditions;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.structure.Structure;

public record MatchStructureCondition(HolderSet<Structure> structures) implements SpawnCondition
{
    public static final MapCodec<MatchStructureCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.STRUCTURE, (Codec)Structure.DIRECT_CODEC).fieldOf("structures").forGetter(MatchStructureCondition::structures)).apply((Applicative)instance, MatchStructureCondition::new));

    @Override
    public SpawnConditionType getType() {
        return FOTSpawnConditions.MATCH_STRUCTURE;
    }

    @Override
    public boolean test(SpawnConditionContext context) {
        return context.level().structureManager().getStructureWithPieceAt(context.blockPos(), this.structures).isValid();
    }

    public static SpawnCondition.Builder structures(HolderSet<Structure> structures) {
        return () -> new MatchStructureCondition(structures);
    }
}

