/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.ai.sensing;

import com.google.common.collect.ImmutableSet;
import com.stevekung.fishofthieves.entity.AbstractFlockFish;
import com.stevekung.fishofthieves.registry.FOTMemoryModuleTypes;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;

public class NearestFlockLeaderSensor
extends Sensor<AbstractFlockFish> {
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of(FOTMemoryModuleTypes.NEAREST_VISIBLE_FLOCK_LEADER);
    }

    protected void doTick(ServerLevel level, AbstractFlockFish livingEntity) {
        List list = level.getEntitiesOfClass(AbstractFlockFish.class, livingEntity.getBoundingBox().inflate(16.0), livingEntityx -> livingEntityx.isLeader() && livingEntityx.isAlive());
        list.sort(Comparator.comparingDouble(arg_0 -> ((AbstractFlockFish)livingEntity).distanceToSqr(arg_0)));
        livingEntity.getBrain().setMemory(FOTMemoryModuleTypes.NEAREST_VISIBLE_FLOCK_LEADER, (Object)list);
    }
}

