/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.DataFixUtils;
import com.stevekung.fishofthieves.entity.AbstractFlockFish;
import com.stevekung.fishofthieves.registry.FOTMemoryModuleTypes;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class CreateFishFlock
extends Behavior<AbstractFlockFish> {
    public CreateFishFlock() {
        super((Map)ImmutableMap.of(FOTMemoryModuleTypes.NEAREST_VISIBLE_SCHOOLING_THIEVES_FISH, (Object)MemoryStatus.VALUE_PRESENT, FOTMemoryModuleTypes.SCHOOL_SIZE, (Object)MemoryStatus.VALUE_PRESENT, FOTMemoryModuleTypes.FOLLOW_FLOCK_COOLDOWN_TICKS, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected void start(ServerLevel level, AbstractFlockFish entity, long gameTime) {
        Optional optional = entity.getBrain().getMemory(FOTMemoryModuleTypes.NEAREST_VISIBLE_SCHOOLING_THIEVES_FISH);
        if (!entity.isFollower() && !entity.isLeader() && optional.isPresent()) {
            Predicate<AbstractFlockFish> canBeFollowed = AbstractFlockFish::canBeFollowed;
            Predicate<AbstractFlockFish> notLeader = Predicate.not(AbstractFlockFish::isLeader);
            Predicate<AbstractFlockFish> notFollower = Predicate.not(AbstractFlockFish::isFollower);
            Predicate<AbstractFlockFish> lineOfSight = arg_0 -> ((AbstractFlockFish)entity).hasLineOfSight(arg_0);
            Predicate<AbstractFlockFish> trophy = AbstractFlockFish::isTrophy;
            Predicate<AbstractFlockFish> hasNoFollowCooldown = Predicate.not(AbstractFlockFish::hasFollowCooldown);
            Optional<AbstractFlockFish> nearestFish = ((List)optional.get()).stream().filter(lineOfSight.and(canBeFollowed).and(notFollower)).findAny();
            AbstractFlockFish leader = (AbstractFlockFish)((Object)DataFixUtils.orElse(nearestFish, (Object)((Object)entity)));
            if (leader.isTrophy()) {
                leader.addThievesFishFollowers(((List)optional.get()).stream().filter(leader::isSameType).filter(lineOfSight.and(notFollower).and(notLeader).and(hasNoFollowCooldown).and(trophy.negate().or(trophy))));
            } else {
                Supplier<Stream> supplier = () -> ((List)optional.get()).stream().filter(lineOfSight.and(notFollower).and(notLeader));
                supplier.get().filter(trophy).findAny().ifPresentOrElse(fish -> fish.addThievesFishFollowers(((Stream)supplier.get()).filter(hasNoFollowCooldown.and(fish::isSameType))), () -> leader.addThievesFishFollowers(((Stream)supplier.get()).filter(hasNoFollowCooldown.and(leader::isSameType))));
            }
        }
    }

    public static int nextStartTick(RandomSource randomSource) {
        return CreateFishFlock.nextStartTick(randomSource, 200);
    }

    public static int nextStartTick(RandomSource randomSource, int nextTicks) {
        return Mth.positiveCeilDiv((int)(nextTicks + randomSource.nextInt(nextTicks) % 20), (int)2);
    }
}

