/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.stevekung.fishofthieves.entity.ThievesFish;
import com.stevekung.fishofthieves.entity.variant.AbstractFishVariant;
import java.util.Optional;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.VariantHolder;

public class GlowFishLayer<V extends AbstractFishVariant, T extends LivingEntity & VariantHolder<Holder<V>>, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    public GlowFishLayer(RenderLayerParent<T, M> renderLayerParent) {
        super(renderLayerParent);
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        Optional<ResourceLocation> glowTexture = ((AbstractFishVariant)((Holder)((VariantHolder)livingEntity).getVariant()).value()).fullGlowTexture();
        if (!livingEntity.isInvisible() && glowTexture.isPresent()) {
            VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.eyes((ResourceLocation)glowTexture.get()));
            float color = ((ThievesFish)livingEntity).getGlowBrightness(ageInTicks);
            this.getParentModel().renderToBuffer(poseStack, vertexConsumer, 0xF00000, OverlayTexture.NO_OVERLAY, FastColor.ARGB32.colorFromFloat((float)1.0f, (float)color, (float)color, (float)color));
        }
    }
}

