/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.block;

import com.mojang.serialization.MapCodec;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PomegranateSaplingBlock
extends BushBlock
implements BonemealableBlock {
    public static final MapCodec<PomegranateSaplingBlock> CODEC = PomegranateSaplingBlock.simpleCodec(PomegranateSaplingBlock::new);
    private static final VoxelShape SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0);

    public PomegranateSaplingBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.growToPomegranatePlant(level, pos, random);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return (level.getRawBrightness(pos, 0) >= 8 || level.canSeeSky(pos)) && super.canSurvive(state, level, pos);
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return random.nextInt(3) == 0;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.growToPomegranatePlant(level, pos, random);
    }

    private void growToPomegranatePlant(ServerLevel level, BlockPos pos, RandomSource randomSource) {
        if (level.getRawBrightness(pos.above(), 0) >= 9) {
            DoublePlantBlock doublePlantBlock = (DoublePlantBlock)FOTBlocks.TALL_POMEGRANATE_PLANT;
            if (randomSource.nextInt(5) == 0 && doublePlantBlock.defaultBlockState().canSurvive((LevelReader)level, pos) && level.isEmptyBlock(pos.above())) {
                DoublePlantBlock.placeAt((LevelAccessor)level, (BlockState)doublePlantBlock.defaultBlockState(), (BlockPos)pos, (int)2);
            } else {
                BlockState blockState = FOTBlocks.POMEGRANATE_PLANT.defaultBlockState();
                level.setBlock(pos, blockState, 2);
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)blockState));
            }
        }
    }
}

