/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BananaClusterBlock
extends Block
implements BonemealableBlock,
SimpleWaterloggedBlock {
    private static final VoxelShape UNDERRIPE_SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    private static final VoxelShape NORMAL_SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final MapCodec<BananaClusterBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Type.CODEC.fieldOf("type").forGetter(BananaClusterBlock::getClusterType), (App)BananaClusterBlock.propertiesCodec()).apply((Applicative)instance, BananaClusterBlock::new));
    private final Type type;

    public BananaClusterBlock(Type type, BlockBehaviour.Properties properties) {
        super(properties);
        this.type = type;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public Type getClusterType() {
        return this.type;
    }

    protected MapCodec<? extends BananaClusterBlock> codec() {
        return CODEC;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return this.type == Type.BARELY_RIPE;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (BananaClusterBlock.canClusterGrow((Level)level, pos) && random.nextInt(5) == 0) {
            this.growBarelyCluster(level, pos);
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return this.type == Type.BARELY_RIPE;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return random.nextInt(6) == 0;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.growBarelyCluster(level, pos);
    }

    private void growBarelyCluster(ServerLevel level, BlockPos pos) {
        level.setBlock(pos, (BlockState)FOTBlocks.RIPE_BANANA_CLUSTER.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos).getType() == Fluids.WATER)), 3);
    }

    public boolean skipRendering(BlockState state, BlockState adjacentState, Direction direction) {
        if (this.type == Type.UNDERRIPE) {
            return false;
        }
        return adjacentState.is((Block)this) && direction.getAxis().isVertical();
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)this.type.block().get());
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.type == Type.UNDERRIPE ? UNDERRIPE_SHAPE : NORMAL_SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED});
    }

    public static boolean canClusterGrow(Level level, BlockPos blockPos) {
        return !level.isRaining() && BananaClusterBlock.isDaySeeSky(level, blockPos);
    }

    public static boolean canClusterPlantGrow(Level level, BlockPos blockPos) {
        return level.isRaining() && BananaClusterBlock.isDaySeeSky(level, blockPos);
    }

    private static boolean isDaySeeSky(Level level, BlockPos blockPos) {
        return level.isDay() && level.canSeeSky(blockPos);
    }

    public static enum Type implements StringRepresentable
    {
        UNDERRIPE(() -> FOTBlocks.UNDERRIPE_BANANA_CLUSTER),
        BARELY_RIPE(() -> FOTBlocks.BARELY_RIPE_BANANA_CLUSTER),
        RIPE(() -> FOTBlocks.RIPE_BANANA_CLUSTER);

        public static final StringRepresentable.EnumCodec<Type> CODEC;
        private final Supplier<Block> block;

        private Type(Supplier<Block> block) {
            this.block = block;
        }

        public Supplier<Block> block() {
            return this.block;
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
        }
    }
}

