/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.block;

import com.stevekung.fishofthieves.block.BananaBlossomBlock;
import com.stevekung.fishofthieves.block.BananaHangingType;
import com.stevekung.fishofthieves.block.BananaLeavesBlock;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTTags;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BananaBlossomPlantBlock
extends BananaBlossomBlock {
    private static final Map<Direction, VoxelShape> SHAPES = Map.of(Direction.NORTH, Shapes.join((VoxelShape)Block.box((double)6.5, (double)9.0, (double)4.5, (double)9.5, (double)11.0, (double)7.5), (VoxelShape)Block.box((double)5.5, (double)11.0, (double)3.5, (double)10.5, (double)16.0, (double)8.5), (BooleanOp)BooleanOp.OR), Direction.WEST, Shapes.join((VoxelShape)Block.box((double)4.5, (double)9.0, (double)6.5, (double)7.5, (double)11.0, (double)9.5), (VoxelShape)Block.box((double)3.5, (double)11.0, (double)5.5, (double)8.5, (double)16.0, (double)10.5), (BooleanOp)BooleanOp.OR), Direction.SOUTH, Shapes.join((VoxelShape)Block.box((double)6.5, (double)9.0, (double)8.5, (double)9.5, (double)11.0, (double)11.5), (VoxelShape)Block.box((double)5.5, (double)11.0, (double)7.5, (double)10.5, (double)16.0, (double)12.5), (BooleanOp)BooleanOp.OR), Direction.EAST, Shapes.join((VoxelShape)Block.box((double)8.5, (double)9.0, (double)6.5, (double)11.5, (double)11.0, (double)9.5), (VoxelShape)Block.box((double)7.5, (double)11.0, (double)5.5, (double)12.5, (double)16.0, (double)10.5), (BooleanOp)BooleanOp.OR));
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<BananaHangingType> HANGING = EnumProperty.create((String)"hanging", BananaHangingType.class);

    public BananaBlossomPlantBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue(HANGING, (Comparable)((Object)BananaHangingType.STEM)));
    }

    @Override
    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState blockState = level.getBlockState(pos.above());
        if (blockState.is(FOTBlocks.BANANA_LEAVES)) {
            return blockState.getValue(BananaLeavesBlock.TYPE) == BananaLeavesBlock.Type.UPPER;
        }
        return blockState.is(FOTTags.Blocks.BANANA_CLUSTER_PLANTS);
    }

    @Override
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (direction == Direction.UP && (neighborState.is(FOTBlocks.BARELY_RIPE_BANANA_CLUSTER_PLANT) || neighborState.is(FOTBlocks.RIPE_BANANA_CLUSTER_PLANT))) {
            return (BlockState)state.setValue(HANGING, (Comparable)((Object)BananaHangingType.CLUSTER));
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.getValue((Property)FACING));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{FACING, HANGING}));
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

