/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.text.markdown;

import de.keksuccino.fancymenu.util.rendering.text.markdown.MarkdownTextFragment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.resources.language.I18n;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownTextBuilder {
    protected StringBuilder builder = new StringBuilder();

    @NotNull
    public static MarkdownTextBuilder create() {
        return new MarkdownTextBuilder();
    }

    public MarkdownTextBuilder addLine(@NotNull String line) {
        this.builder.append(Objects.requireNonNull(line)).append("\n");
        return this;
    }

    public MarkdownTextBuilder addLocalizedLine(@NotNull String key, Object ... placeholders) {
        return this.addLine(I18n.get((String)key, (Object[])placeholders));
    }

    public MarkdownTextBuilder addHeadline(@NotNull MarkdownTextFragment.HeadlineType headlineType, @NotNull String headline) {
        Objects.requireNonNull(headlineType);
        if (headlineType == MarkdownTextFragment.HeadlineType.BIG) {
            headline = "### " + (String)headline;
        } else if (headlineType == MarkdownTextFragment.HeadlineType.BIGGER) {
            headline = "## " + (String)headline;
        } else if (headlineType == MarkdownTextFragment.HeadlineType.BIGGEST) {
            headline = "# " + (String)headline;
        }
        return this.addLine((String)headline);
    }

    public MarkdownTextBuilder addLocalizedHeadline(@NotNull MarkdownTextFragment.HeadlineType headlineType, @NotNull String key, Object ... placeholders) {
        return this.addHeadline(headlineType, I18n.get((String)key, (Object[])placeholders));
    }

    public MarkdownTextBuilder addEmptyLine() {
        return this.addLine("");
    }

    public MarkdownTextBuilder addTable(@NotNull List<List<String>> rows, @Nullable List<TableCellAlignment> alignments) {
        int i;
        Objects.requireNonNull(rows);
        if (rows.isEmpty()) {
            return this;
        }
        int columnCount = rows.get(0).size();
        List<String> headerRow = rows.get(0);
        this.builder.append("|");
        for (String cell : headerRow) {
            this.builder.append(" ").append(cell).append(" |");
        }
        this.builder.append("\n");
        this.builder.append("|");
        block6: for (i = 0; i < columnCount; ++i) {
            TableCellAlignment align = alignments != null && i < alignments.size() ? alignments.get(i) : TableCellAlignment.LEFT;
            switch (align.ordinal()) {
                case 0: {
                    this.builder.append(":---------|");
                    continue block6;
                }
                case 1: {
                    this.builder.append(":---------:|");
                    continue block6;
                }
                case 2: {
                    this.builder.append("---------:|");
                }
            }
        }
        this.builder.append("\n");
        for (i = 1; i < rows.size(); ++i) {
            List<String> row = rows.get(i);
            this.builder.append("|");
            for (int j = 0; j < columnCount; ++j) {
                String cell = j < row.size() ? row.get(j) : "";
                this.builder.append(" ").append(cell).append(" |");
            }
            this.builder.append("\n");
        }
        return this;
    }

    public MarkdownTextBuilder addSimpleTable(@NotNull String[][] data) {
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        for (String[] row : data) {
            rows.add(Arrays.asList(row));
        }
        return this.addTable(rows, null);
    }

    @NotNull
    public String build() {
        return this.builder.toString();
    }

    public String toString() {
        return this.build();
    }

    public static enum TableCellAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }
}

