/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.tooltip;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.SerializedElement;
import de.keksuccino.fancymenu.customization.element.elements.tooltip.TooltipEditorElement;
import de.keksuccino.fancymenu.customization.element.elements.tooltip.TooltipElement;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.text.markdown.MarkdownRenderer;
import de.keksuccino.konkrete.math.MathUtils;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TooltipElementBuilder
extends ElementBuilder<TooltipElement, TooltipEditorElement> {
    public TooltipElementBuilder() {
        super("tooltip");
    }

    @Override
    @NotNull
    public TooltipElement buildDefaultInstance() {
        TooltipElement element = new TooltipElement(this);
        element.baseWidth = 200;
        element.baseHeight = 40;
        element.setSource(TooltipElement.SourceMode.DIRECT, "------------------");
        return element;
    }

    @Override
    public TooltipElement deserializeElement(@NotNull SerializedElement serialized) {
        String bulletListSpacing;
        String bulletListIndent;
        String bulletListDotColor;
        String quoteItalic;
        String quoteIndent;
        String quoteColor;
        String hyperlinkColor;
        String separationLineColor;
        String headlineLineColor;
        String codeBlockMultiColor;
        String codeBlockSingleColor;
        String removeHtmlBreaks;
        String autoLineWrapping;
        String lineSpacingString;
        String textBorderString;
        String baseColorString;
        String scaleString;
        String caseModeString;
        String shadowString;
        String nineSliceBorderLeftString;
        String nineSliceBorderBottomString;
        String nineSliceBorderRightString;
        TooltipElement.SourceMode s;
        String sourceModeString;
        TooltipElement element = new TooltipElement(this);
        element.baseWidth = 200;
        element.baseHeight = 40;
        element.interactable = this.deserializeBoolean(element.interactable, serialized.getValue("interactable"));
        element.mouseFollowing = this.deserializeBoolean(element.mouseFollowing, serialized.getValue("mouse_following"));
        element.source = serialized.getValue("source");
        if (element.source != null) {
            element.source = element.source.replace("%n%", "\n");
        }
        if ((sourceModeString = serialized.getValue("source_mode")) != null && (s = TooltipElement.SourceMode.getByName(sourceModeString)) != null) {
            element.sourceMode = s;
        }
        element.backgroundTexture = TooltipElementBuilder.deserializeImageResourceSupplier(serialized.getValue("background_texture"));
        String nineSliceBorderTopString = serialized.getValue("nine_slice_border_top");
        if (nineSliceBorderTopString != null && MathUtils.isInteger((String)nineSliceBorderTopString)) {
            element.nineSliceBorderTop = Integer.parseInt(nineSliceBorderTopString);
        }
        if ((nineSliceBorderRightString = serialized.getValue("nine_slice_border_right")) != null && MathUtils.isInteger((String)nineSliceBorderRightString)) {
            element.nineSliceBorderRight = Integer.parseInt(nineSliceBorderRightString);
        }
        if ((nineSliceBorderBottomString = serialized.getValue("nine_slice_border_bottom")) != null && MathUtils.isInteger((String)nineSliceBorderBottomString)) {
            element.nineSliceBorderBottom = Integer.parseInt(nineSliceBorderBottomString);
        }
        if ((nineSliceBorderLeftString = serialized.getValue("nine_slice_border_left")) != null && MathUtils.isInteger((String)nineSliceBorderLeftString)) {
            element.nineSliceBorderLeft = Integer.parseInt(nineSliceBorderLeftString);
        }
        if ((shadowString = serialized.getValue("shadow")) != null) {
            if (shadowString.equals("false")) {
                element.markdownRenderer.setTextShadow(false);
            }
            if (shadowString.equals("true")) {
                element.markdownRenderer.setTextShadow(true);
            }
        }
        if ((caseModeString = serialized.getValue("case_mode")) != null) {
            if (caseModeString.equals("lower")) {
                element.markdownRenderer.setTextCase(MarkdownRenderer.TextCase.ALL_LOWER);
            }
            if (caseModeString.equals("upper")) {
                element.markdownRenderer.setTextCase(MarkdownRenderer.TextCase.ALL_UPPER);
            }
        }
        if ((scaleString = serialized.getValue("scale")) != null && MathUtils.isFloat((String)scaleString)) {
            element.markdownRenderer.setTextBaseScale(Float.parseFloat(scaleString));
        }
        if ((baseColorString = serialized.getValue("base_color")) != null) {
            DrawableColor c = DrawableColor.of(baseColorString);
            element.markdownRenderer.setTextBaseColor(c);
        }
        if ((textBorderString = serialized.getValue("text_border")) != null && MathUtils.isInteger((String)textBorderString)) {
            element.markdownRenderer.setBorder(Integer.parseInt(textBorderString));
        }
        if ((lineSpacingString = serialized.getValue("line_spacing")) != null && MathUtils.isInteger((String)lineSpacingString)) {
            element.markdownRenderer.setLineSpacing(Integer.parseInt(lineSpacingString));
        }
        if ((autoLineWrapping = serialized.getValue("auto_line_wrapping")) != null) {
            if (autoLineWrapping.equals("true")) {
                element.markdownRenderer.setAutoLineBreakingEnabled(true);
            }
            if (autoLineWrapping.equals("false")) {
                element.markdownRenderer.setAutoLineBreakingEnabled(false);
            }
        }
        if ((removeHtmlBreaks = serialized.getValue("remove_html_breaks")) != null) {
            if (removeHtmlBreaks.equals("true")) {
                element.markdownRenderer.setRemoveHtmlBreaks(true);
            }
            if (removeHtmlBreaks.equals("false")) {
                element.markdownRenderer.setRemoveHtmlBreaks(false);
            }
        }
        if ((codeBlockSingleColor = serialized.getValue("code_block_single_color")) != null) {
            element.markdownRenderer.setCodeBlockSingleLineColor(DrawableColor.of(codeBlockSingleColor));
        }
        if ((codeBlockMultiColor = serialized.getValue("code_block_multi_color")) != null) {
            element.markdownRenderer.setCodeBlockMultiLineColor(DrawableColor.of(codeBlockMultiColor));
        }
        if ((headlineLineColor = serialized.getValue("headline_line_color")) != null) {
            element.markdownRenderer.setHeadlineLineColor(DrawableColor.of(headlineLineColor));
        }
        if ((separationLineColor = serialized.getValue("separation_line_color")) != null) {
            element.markdownRenderer.setSeparationLineColor(DrawableColor.of(separationLineColor));
        }
        if ((hyperlinkColor = serialized.getValue("hyperlink_color")) != null) {
            element.markdownRenderer.setHyperlinkColor(DrawableColor.of(hyperlinkColor));
        }
        if ((quoteColor = serialized.getValue("quote_color")) != null) {
            element.markdownRenderer.setQuoteColor(DrawableColor.of(quoteColor));
        }
        if ((quoteIndent = serialized.getValue("quote_indent")) != null && MathUtils.isInteger((String)quoteIndent)) {
            element.markdownRenderer.setQuoteIndent(Integer.parseInt(quoteIndent));
        }
        if ((quoteItalic = serialized.getValue("quote_italic")) != null) {
            if (quoteItalic.equals("true")) {
                element.markdownRenderer.setQuoteItalic(true);
            }
            if (quoteItalic.equals("false")) {
                element.markdownRenderer.setQuoteItalic(false);
            }
        }
        if ((bulletListDotColor = serialized.getValue("bullet_list_dot_color")) != null) {
            element.markdownRenderer.setBulletListDotColor(DrawableColor.of(bulletListDotColor));
        }
        if ((bulletListIndent = serialized.getValue("bullet_list_indent")) != null && MathUtils.isInteger((String)bulletListIndent)) {
            element.markdownRenderer.setBulletListIndent(Integer.parseInt(bulletListIndent));
        }
        if ((bulletListSpacing = serialized.getValue("bullet_list_spacing")) != null && MathUtils.isInteger((String)bulletListSpacing)) {
            element.markdownRenderer.setBulletListSpacing(Integer.parseInt(bulletListSpacing));
        }
        element.markdownRenderer.setParseMarkdown(this.deserializeBoolean(true, serialized.getValue("parse_markdown")));
        element.markdownRenderer.refreshRenderer();
        element.setSource(element.sourceMode, element.source);
        return element;
    }

    @Override
    protected SerializedElement serializeElement(@NotNull TooltipElement element, @NotNull SerializedElement serializeTo) {
        serializeTo.putProperty("interactable", "" + element.interactable);
        serializeTo.putProperty("mouse_following", "" + element.mouseFollowing);
        if (element.source != null) {
            serializeTo.putProperty("source", element.source.replace("\n", "%n%"));
        }
        serializeTo.putProperty("source_mode", element.sourceMode.name);
        if (element.backgroundTexture != null) {
            serializeTo.putProperty("background_texture", element.backgroundTexture.getSourceWithPrefix());
        }
        serializeTo.putProperty("nine_slice_border_top", "" + element.nineSliceBorderTop);
        serializeTo.putProperty("nine_slice_border_right", "" + element.nineSliceBorderRight);
        serializeTo.putProperty("nine_slice_border_bottom", "" + element.nineSliceBorderBottom);
        serializeTo.putProperty("nine_slice_border_left", "" + element.nineSliceBorderLeft);
        serializeTo.putProperty("shadow", "" + element.markdownRenderer.isTextShadow());
        if (element.markdownRenderer.getTextCase() == MarkdownRenderer.TextCase.ALL_LOWER) {
            serializeTo.putProperty("case_mode", "lower");
        } else if (element.markdownRenderer.getTextCase() == MarkdownRenderer.TextCase.ALL_UPPER) {
            serializeTo.putProperty("case_mode", "upper");
        }
        serializeTo.putProperty("scale", "" + element.markdownRenderer.getTextBaseScale());
        serializeTo.putProperty("base_color", element.markdownRenderer.getTextBaseColor().getHex());
        serializeTo.putProperty("text_border", "" + (int)element.markdownRenderer.getBorder());
        serializeTo.putProperty("line_spacing", "" + (int)element.markdownRenderer.getLineSpacing());
        serializeTo.putProperty("auto_line_wrapping", "" + element.markdownRenderer.isAutoLineBreakingEnabled());
        serializeTo.putProperty("remove_html_breaks", "" + element.markdownRenderer.isRemoveHtmlBreaks());
        serializeTo.putProperty("code_block_single_color", element.markdownRenderer.getCodeBlockSingleLineColor().getHex());
        serializeTo.putProperty("code_block_multi_color", element.markdownRenderer.getCodeBlockMultiLineColor().getHex());
        serializeTo.putProperty("headline_line_color", element.markdownRenderer.getHeadlineUnderlineColor().getHex());
        serializeTo.putProperty("separation_line_color", element.markdownRenderer.getSeparationLineColor().getHex());
        serializeTo.putProperty("hyperlink_color", element.markdownRenderer.getHyperlinkColor().getHex());
        serializeTo.putProperty("quote_color", element.markdownRenderer.getQuoteColor().getHex());
        serializeTo.putProperty("quote_indent", "" + element.markdownRenderer.getQuoteIndent());
        serializeTo.putProperty("quote_italic", "" + element.markdownRenderer.isQuoteItalic());
        serializeTo.putProperty("bullet_list_dot_color", element.markdownRenderer.getBulletListDotColor().getHex());
        serializeTo.putProperty("bullet_list_indent", "" + element.markdownRenderer.getBulletListIndent());
        serializeTo.putProperty("bullet_list_spacing", "" + element.markdownRenderer.getBulletListSpacing());
        serializeTo.putProperty("parse_markdown", "" + element.markdownRenderer.isParseMarkdown());
        return serializeTo;
    }

    @Override
    @NotNull
    public TooltipEditorElement wrapIntoEditorElement(@NotNull TooltipElement element, @NotNull LayoutEditorScreen editor) {
        return new TooltipEditorElement(element, editor);
    }

    @Override
    @NotNull
    public Component getDisplayName(@Nullable AbstractElement element) {
        return Component.translatable((String)"fancymenu.elements.tooltip");
    }

    @Override
    @Nullable
    public Component[] getDescription(@Nullable AbstractElement element) {
        return LocalizationUtils.splitLocalizedLines("fancymenu.elements.tooltip.desc", new String[0]);
    }
}

