/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.checkbox;

import de.keksuccino.fancymenu.customization.action.blocks.AbstractExecutableBlock;
import de.keksuccino.fancymenu.customization.action.blocks.ExecutableBlockDeserializer;
import de.keksuccino.fancymenu.customization.action.blocks.GenericExecutableBlock;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.SerializedElement;
import de.keksuccino.fancymenu.customization.element.elements.checkbox.CheckboxEditorElement;
import de.keksuccino.fancymenu.customization.element.elements.checkbox.CheckboxElement;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementContainer;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheckboxElementBuilder
extends ElementBuilder<CheckboxElement, CheckboxEditorElement> {
    public CheckboxElementBuilder() {
        super("checkbox");
    }

    @Override
    @NotNull
    public CheckboxElement buildDefaultInstance() {
        CheckboxElement element = new CheckboxElement(this);
        element.baseWidth = 20;
        element.baseHeight = 20;
        return element;
    }

    @Override
    public CheckboxElement deserializeElement(@NotNull SerializedElement serialized) {
        LoadingRequirementContainer c;
        AbstractExecutableBlock b;
        CheckboxElement element = this.buildDefaultInstance();
        String checkboxExecutableBlockId = serialized.getValue("checkbox_element_executable_block_identifier");
        if (checkboxExecutableBlockId != null && (b = ExecutableBlockDeserializer.deserializeWithIdentifier(serialized, checkboxExecutableBlockId)) instanceof GenericExecutableBlock) {
            GenericExecutableBlock g;
            element.actionExecutor = g = (GenericExecutableBlock)b;
        }
        element.hoverSound = CheckboxElementBuilder.deserializeAudioResourceSupplier(serialized.getValue("hoversound"));
        element.clickSound = CheckboxElementBuilder.deserializeAudioResourceSupplier(serialized.getValue("clicksound"));
        element.tooltip = serialized.getValue("description");
        element.backgroundTextureNormal = CheckboxElementBuilder.deserializeImageResourceSupplier(serialized.getValue("background_texture_normal"));
        element.backgroundTextureHover = CheckboxElementBuilder.deserializeImageResourceSupplier(serialized.getValue("background_texture_hover"));
        element.backgroundTextureInactive = CheckboxElementBuilder.deserializeImageResourceSupplier(serialized.getValue("background_texture_inactive"));
        element.checkmarkTexture = CheckboxElementBuilder.deserializeImageResourceSupplier(serialized.getValue("checkmark_texture"));
        element.navigatable = this.deserializeBoolean(element.navigatable, serialized.getValue("navigatable"));
        String activeStateRequirementContainerIdentifier = serialized.getValue("widget_active_state_requirement_container_identifier");
        if (activeStateRequirementContainerIdentifier != null && (c = LoadingRequirementContainer.deserializeWithIdentifier(activeStateRequirementContainerIdentifier, serialized)) != null) {
            element.activeStateSupplier = c;
        }
        element.prepareExecutableBlock();
        return element;
    }

    @Override
    @Nullable
    public CheckboxElement deserializeElementInternal(@NotNull SerializedElement serialized) {
        CheckboxElement element = (CheckboxElement)super.deserializeElementInternal(serialized);
        if (element != null) {
            element.prepareLoadingRequirementContainer();
        }
        return element;
    }

    @Override
    @NotNull
    protected SerializedElement serializeElement(@NotNull CheckboxElement element, @NotNull SerializedElement serializeTo) {
        serializeTo.putProperty("checkbox_element_executable_block_identifier", element.actionExecutor.identifier);
        element.actionExecutor.serializeToExistingPropertyContainer(serializeTo);
        if (element.hoverSound != null) {
            serializeTo.putProperty("hoversound", element.hoverSound.getSourceWithPrefix());
        }
        if (element.clickSound != null) {
            serializeTo.putProperty("clicksound", element.clickSound.getSourceWithPrefix());
        }
        if (element.tooltip != null) {
            serializeTo.putProperty("description", element.tooltip);
        }
        if (element.backgroundTextureNormal != null) {
            serializeTo.putProperty("background_texture_normal", element.backgroundTextureNormal.getSourceWithPrefix());
        }
        if (element.backgroundTextureHover != null) {
            serializeTo.putProperty("background_texture_hover", element.backgroundTextureHover.getSourceWithPrefix());
        }
        if (element.backgroundTextureInactive != null) {
            serializeTo.putProperty("background_texture_inactive", element.backgroundTextureInactive.getSourceWithPrefix());
        }
        if (element.checkmarkTexture != null) {
            serializeTo.putProperty("checkmark_texture", element.checkmarkTexture.getSourceWithPrefix());
        }
        serializeTo.putProperty("navigatable", "" + element.navigatable);
        serializeTo.putProperty("widget_active_state_requirement_container_identifier", element.activeStateSupplier.identifier);
        element.activeStateSupplier.serializeToExistingPropertyContainer(serializeTo);
        return serializeTo;
    }

    @Override
    @NotNull
    public CheckboxEditorElement wrapIntoEditorElement(@NotNull CheckboxElement element, @NotNull LayoutEditorScreen editor) {
        return new CheckboxEditorElement(element, editor);
    }

    @Override
    @NotNull
    public Component getDisplayName(@Nullable AbstractElement element) {
        return Component.translatable((String)"fancymenu.elements.checkbox");
    }

    @Override
    @Nullable
    public Component[] getDescription(@Nullable AbstractElement element) {
        return LocalizationUtils.splitLocalizedLines("fancymenu.elements.checkbox.desc", new String[0]);
    }
}

