/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.customgui;

import de.keksuccino.fancymenu.customization.customgui.CustomGui;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomGuiBaseScreen
extends Screen {
    protected final CustomGui gui;
    protected final Screen overrideScreen;
    protected final Screen parentScreen;

    public CustomGuiBaseScreen(@NotNull CustomGui customGui, @Nullable Screen parentScreen, @Nullable Screen overrideScreen) {
        super((Component)Component.empty());
        this.gui = customGui;
        this.overrideScreen = overrideScreen;
        this.parentScreen = parentScreen;
    }

    public void onClose() {
        Minecraft.getInstance().setScreen(this.parentScreen);
    }

    public boolean shouldCloseOnEsc() {
        return this.gui.allowEsc;
    }

    public boolean isPauseScreen() {
        return this.gui.pauseGame;
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        super.render(graphics, mouseX, mouseY, partial);
        String title = this.getTitleString();
        MutableComponent titleComp = LocalizationUtils.isLocalizationKey(title) ? Component.translatable((String)title) : Component.literal((String)PlaceholderParser.replacePlaceholders(title));
        graphics.drawCenteredString(this.font, (Component)titleComp, this.width / 2, 8, -1);
    }

    public void renderBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (Minecraft.getInstance().level == null || !this.gui.worldBackground) {
            this.renderPanorama(graphics, partial);
        }
        this.renderBlurredBackground(partial);
        this.renderMenuBackground(graphics);
    }

    @NotNull
    public String getTitleString() {
        return this.gui.title;
    }

    @NotNull
    public String getIdentifier() {
        return this.gui.identifier;
    }

    @Nullable
    public Screen getOverriddenScreen() {
        return this.overrideScreen;
    }
}

