/*
 * Decompiled with CFR 0.152.
 */
package ianm1647.expandeddelight.common.block;

import com.mojang.serialization.MapCodec;
import ianm1647.expandeddelight.common.block.entity.JuicerBlockEntity;
import ianm1647.expandeddelight.common.registry.EDBlockEntityTypes;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import vectorwing.farmersdelight.common.utility.MathUtils;

public class JuicerBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING;
    public static final BooleanProperty WATERLOGGED;
    public static final VoxelShape SHAPE_NORTH;
    private static final VoxelShape SHAPE_SOUTH;
    private static final VoxelShape SHAPE_EAST;
    private static final VoxelShape SHAPE_WEST;
    public static final MapCodec<JuicerBlock> CODEC;

    public JuicerBlock() {
        super(BlockBehaviour.Properties.of().strength(2.0f, 3.0f).sound(SoundType.WOOD));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public JuicerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public ItemInteractionResult useItemOn(ItemStack heldStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (!level.isClientSide) {
            BlockEntity tileEntity = level.getBlockEntity(pos);
            if (tileEntity instanceof JuicerBlockEntity) {
                JuicerBlockEntity juicerBlockEntity = (JuicerBlockEntity)tileEntity;
                ItemStack servingStack = juicerBlockEntity.useHeldItemOnDrink(heldStack);
                if (servingStack != ItemStack.EMPTY) {
                    if (!player.getInventory().add(servingStack)) {
                        player.drop(servingStack, false);
                    }
                    level.playSound(null, pos, SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else {
                    player.openMenu((MenuProvider)juicerBlockEntity, pos);
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.SUCCESS;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
        };
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
        };
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluid = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.getType() == Fluids.WATER));
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return state;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        ItemStack stack = super.getCloneItemStack(level, pos, state);
        Optional juicer = level.getBlockEntity(pos, EDBlockEntityTypes.JUICER.get());
        if (juicer.isPresent()) {
            stack = ((JuicerBlockEntity)((Object)juicer.get())).getAsItem();
        }
        return stack;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity tileEntity = level.getBlockEntity(pos);
            if (tileEntity instanceof JuicerBlockEntity) {
                JuicerBlockEntity juicerBlockEntity = (JuicerBlockEntity)tileEntity;
                Containers.dropContents((Level)level, (BlockPos)pos, juicerBlockEntity.getDroppableInventory());
                juicerBlockEntity.getUsedRecipesAndPopExperience(level, Vec3.atCenterOf((Vec3i)pos));
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        BlockEntity tileEntity = level.getBlockEntity(pos);
        if (tileEntity instanceof JuicerBlockEntity) {
            ItemStackHandler inventory = ((JuicerBlockEntity)tileEntity).getInventory();
            return MathUtils.calcRedstoneFromItemHandler((IItemHandlerModifiable)inventory);
        }
        return 0;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return EDBlockEntityTypes.JUICER.get().create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntity) {
        return level.isClientSide ? JuicerBlock.createTickerHelper(blockEntity, EDBlockEntityTypes.JUICER.get(), JuicerBlockEntity::animationTick) : JuicerBlock.createTickerHelper(blockEntity, EDBlockEntityTypes.JUICER.get(), JuicerBlockEntity::juicingTick);
    }

    static {
        CODEC = JuicerBlock.simpleCodec(JuicerBlock::new);
        FACING = BlockStateProperties.HORIZONTAL_FACING;
        WATERLOGGED = BlockStateProperties.WATERLOGGED;
        SHAPE_NORTH = Shapes.or((VoxelShape)Shapes.box((double)0.1875, (double)0.375, (double)0.1875, (double)0.8125, (double)1.25, (double)0.8125), (VoxelShape[])new VoxelShape[]{Shapes.box((double)0.375, (double)1.25, (double)0.375, (double)0.625, (double)1.375, (double)0.625), Shapes.box((double)0.4375, (double)1.3125, (double)0.4375, (double)0.5625, (double)1.75, (double)0.5625), Shapes.box((double)0.114276875, (double)1.5, (double)0.385723125, (double)0.864276875, (double)1.625, (double)0.635723125), Shapes.box((double)0.0625, (double)0.0, (double)0.8125, (double)0.1875, (double)0.25, (double)0.9375), Shapes.box((double)0.8125, (double)0.0, (double)0.8125, (double)0.9375, (double)0.25, (double)0.9375), Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.1875, (double)0.25, (double)0.1875), Shapes.box((double)0.3125, (double)0.3125, (double)0.0, (double)0.4375, (double)0.5, (double)0.1875), Shapes.box((double)0.5625, (double)0.3125, (double)0.0, (double)0.6875, (double)0.5, (double)0.1875), Shapes.box((double)0.8125, (double)0.0, (double)0.0625, (double)0.9375, (double)0.25, (double)0.1875), Shapes.box((double)0.0625, (double)0.25, (double)0.0625, (double)0.9375, (double)0.375, (double)0.9375), Shapes.box((double)0.4375, (double)0.3125, (double)0.0, (double)0.5625, (double)0.375, (double)0.0625)});
        SHAPE_SOUTH = Shapes.or((VoxelShape)Shapes.box((double)0.1875, (double)0.375, (double)0.1875, (double)0.8125, (double)1.25, (double)0.8125), (VoxelShape[])new VoxelShape[]{Shapes.box((double)0.375, (double)1.25, (double)0.375, (double)0.625, (double)1.375, (double)0.625), Shapes.box((double)0.4375, (double)1.3125, (double)0.4375, (double)0.5625, (double)1.75, (double)0.5625), Shapes.box((double)0.13572312499999994, (double)1.5, (double)0.36427687500000006, (double)0.885723125, (double)1.625, (double)0.614276875), Shapes.box((double)0.8125, (double)0.0, (double)0.0625, (double)0.9375, (double)0.25, (double)0.1875), Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.1875, (double)0.25, (double)0.1875), Shapes.box((double)0.8125, (double)0.0, (double)0.8125, (double)0.9375, (double)0.25, (double)0.9375), Shapes.box((double)0.5625, (double)0.3125, (double)0.8125, (double)0.6875, (double)0.5, (double)1.0), Shapes.box((double)0.3125, (double)0.3125, (double)0.8125, (double)0.4375, (double)0.5, (double)1.0), Shapes.box((double)0.0625, (double)0.0, (double)0.8125, (double)0.1875, (double)0.25, (double)0.9375), Shapes.box((double)0.0625, (double)0.25, (double)0.0625, (double)0.9375, (double)0.375, (double)0.9375), Shapes.box((double)0.4375, (double)0.3125, (double)0.9375, (double)0.5625, (double)0.375, (double)1.0)});
        SHAPE_EAST = Shapes.or((VoxelShape)Shapes.box((double)0.1875, (double)0.375, (double)0.1875, (double)0.8125, (double)1.25, (double)0.8125), (VoxelShape[])new VoxelShape[]{Shapes.box((double)0.375, (double)1.25, (double)0.375, (double)0.625, (double)1.375, (double)0.625), Shapes.box((double)0.4375, (double)1.3125, (double)0.4375, (double)0.5625, (double)1.75, (double)0.5625), Shapes.box((double)0.36427687500000006, (double)1.5, (double)0.11427687500000006, (double)0.614276875, (double)1.625, (double)0.864276875), Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.1875, (double)0.25, (double)0.1875), Shapes.box((double)0.0625, (double)0.0, (double)0.8125, (double)0.1875, (double)0.25, (double)0.9375), Shapes.box((double)0.8125, (double)0.0, (double)0.0625, (double)0.9375, (double)0.25, (double)0.1875), Shapes.box((double)0.8125, (double)0.3125, (double)0.3125, (double)1.0, (double)0.5, (double)0.4375), Shapes.box((double)0.8125, (double)0.3125, (double)0.5625, (double)1.0, (double)0.5, (double)0.6875), Shapes.box((double)0.8125, (double)0.0, (double)0.8125, (double)0.9375, (double)0.25, (double)0.9375), Shapes.box((double)0.0625, (double)0.25, (double)0.0625, (double)0.9375, (double)0.375, (double)0.9375), Shapes.box((double)0.9375, (double)0.3125, (double)0.4375, (double)1.0, (double)0.375, (double)0.5625)});
        SHAPE_WEST = Shapes.or((VoxelShape)Shapes.box((double)0.1875, (double)0.375, (double)0.1875, (double)0.8125, (double)1.25, (double)0.8125), (VoxelShape[])new VoxelShape[]{Shapes.box((double)0.375, (double)1.25, (double)0.375, (double)0.625, (double)1.375, (double)0.625), Shapes.box((double)0.4375, (double)1.3125, (double)0.4375, (double)0.5625, (double)1.75, (double)0.5625), Shapes.box((double)0.38572312499999994, (double)1.5, (double)0.13572312499999994, (double)0.635723125, (double)1.625, (double)0.885723125), Shapes.box((double)0.8125, (double)0.0, (double)0.8125, (double)0.9375, (double)0.25, (double)0.9375), Shapes.box((double)0.8125, (double)0.0, (double)0.0625, (double)0.9375, (double)0.25, (double)0.1875), Shapes.box((double)0.0625, (double)0.0, (double)0.8125, (double)0.1875, (double)0.25, (double)0.9375), Shapes.box((double)0.0, (double)0.3125, (double)0.5625, (double)0.1875, (double)0.5, (double)0.6875), Shapes.box((double)0.0, (double)0.3125, (double)0.3125, (double)0.1875, (double)0.5, (double)0.4375), Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.1875, (double)0.25, (double)0.1875), Shapes.box((double)0.0625, (double)0.25, (double)0.0625, (double)0.9375, (double)0.375, (double)0.9375), Shapes.box((double)0.0, (double)0.3125, (double)0.4375, (double)0.0625, (double)0.375, (double)0.5625)});
    }
}

