/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.walkways;

import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import rbasamoyai.escalated.advancements.WalkwayTravelTracker;
import rbasamoyai.escalated.walkways.WalkwayBlock;
import rbasamoyai.escalated.walkways.WalkwayHelper;
import rbasamoyai.escalated.walkways.WalkwayMovementHandler;
import rbasamoyai.escalated.walkways.WalkwaySlope;

public class WalkwayBlockEntity
extends KineticBlockEntity {
    public Map<Entity, WalkwayMovementHandler.TransportedEntityInfo> passengers;
    public int walkwayLength;
    public int walkwayWidth = 1;
    @Nullable
    protected BlockPos controller;
    protected BlockPos widthReferencePos = this.getBlockPos();
    public float visualProgress = 0.0f;
    protected int updateCount = 0;
    private DyeColor color = null;
    public boolean resetClientRender;
    public boolean lazyResetClientRender;

    public WalkwayBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.setLazyTickRate(3);
    }

    public void tick() {
        if (this.walkwayLength == 0) {
            WalkwayBlock.initWalkway(this.level, this.worldPosition);
        }
        if (this.level.isClientSide && this.lazyResetClientRender) {
            this.lazyResetClientRender = false;
            this.resetClientRender = true;
        }
        super.tick();
        if (!(this.level.getBlockState(this.worldPosition).getBlock() instanceof WalkwayBlock)) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        if (this.updateCount <= 0) {
            this.visualProgress += this.getWalkwayMovementSpeed();
            if (Math.abs(this.visualProgress) > 0.5f) {
                this.visualProgress = Math.signum(this.visualProgress) * (Math.abs(this.visualProgress) % 0.5f);
            }
            this.updateNeighbors();
        } else {
            this.updateCount = Math.max(0, this.updateCount - 1);
        }
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.level.getGameTime() % 40L == 0L) {
            this.sendData();
        }
        if (this.passengers == null) {
            this.passengers = new HashMap<Entity, WalkwayMovementHandler.TransportedEntityInfo>();
        }
        Iterator<Map.Entry<Entity, WalkwayMovementHandler.TransportedEntityInfo>> iter = this.passengers.entrySet().iterator();
        while (iter.hasNext()) {
            WalkwaySlope slope;
            Map.Entry<Entity, WalkwayMovementHandler.TransportedEntityInfo> entry = iter.next();
            Entity entity = entry.getKey();
            WalkwayMovementHandler.TransportedEntityInfo info = entry.getValue();
            boolean canBeTransported = WalkwayMovementHandler.canBeTransported(entity);
            boolean leftTheBelt = info.getTicksSinceLastCollision() > 3;
            BlockPos lastCollidedPos = info.lastCollidedPos;
            BlockState lastCollidedState = info.lastCollidedState;
            Block block = lastCollidedState.getBlock();
            if (block instanceof WalkwayBlock) {
                WalkwayBlock other = (WalkwayBlock)block;
                v0 = other.getWalkwaySlope(lastCollidedState);
            } else {
                v0 = slope = WalkwaySlope.TERMINAL;
            }
            if (leftTheBelt && slope != WalkwaySlope.TERMINAL && slope != WalkwaySlope.HORIZONTAL && this.level.getBlockEntity(lastCollidedPos) instanceof WalkwayBlockEntity && entity.getBoundingBox().intersects(new AABB(lastCollidedPos).inflate(0.0, 0.5, 0.0))) {
                info.refresh(lastCollidedPos, info.lastCollidedState);
                leftTheBelt = false;
            }
            if (!canBeTransported || leftTheBelt) {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (!this.level.isClientSide) {
                        WalkwayTravelTracker.stopTrackingPlayerOnWalkway(player);
                    }
                }
                iter.remove();
                continue;
            }
            info.tick();
            WalkwayMovementHandler.transportEntity(this, entity, info);
        }
    }

    public void attachKinetics() {
        if (this.remove) {
            return;
        }
        super.attachKinetics();
    }

    public void updateNeighbors() {
        int actualWidth;
        WalkwayBlock currentWalkway = null;
        BlockState thisState = this.getBlockState();
        Block block = thisState.getBlock();
        if (!(block instanceof WalkwayBlock)) {
            return;
        }
        WalkwayBlock walkwayBlock = (WalkwayBlock)block;
        BlockPos pos = this.getBlockPos();
        BlockPos referencePos = this.widthReferencePos;
        Direction facing = walkwayBlock.getFacing(thisState);
        Direction left = facing.getCounterClockWise();
        int ITERATE_LIMIT = this.walkwayWidth + 2;
        ArrayList<WalkwayBlockEntity> updateSecondPass = new ArrayList<WalkwayBlockEntity>();
        HashSet<BlockPos> iteratedBlocks = new HashSet<BlockPos>();
        iteratedBlocks.add(pos);
        block0: for (Direction dir : Iterate.directionsInAxis((Direction.Axis)left.getAxis())) {
            BlockPos currentPos;
            BlockState currentState;
            Block block2;
            for (int i = 0; i < ITERATE_LIMIT && (block2 = (currentState = this.level.getBlockState(currentPos = pos.relative(dir, i))).getBlock()) instanceof WalkwayBlock; ++i) {
                WalkwayBlock otherWalkway;
                currentWalkway = otherWalkway = (WalkwayBlock)block2;
                if (i > 0) {
                    BlockEntity blockEntity = this.level.getBlockEntity(currentPos);
                    if (!(blockEntity instanceof WalkwayBlockEntity)) continue block0;
                    WalkwayBlockEntity otherWalkwayBE = (WalkwayBlockEntity)blockEntity;
                    iteratedBlocks.add(currentPos);
                    updateSecondPass.add(otherWalkwayBE);
                }
                if (!currentWalkway.connectedToWalkwayOnSide(this.level, currentState, currentPos, dir)) continue block0;
            }
        }
        if (!iteratedBlocks.contains(referencePos)) {
            this.widthReferencePos = pos;
        }
        this.walkwayWidth = actualWidth = iteratedBlocks.size();
        for (WalkwayBlockEntity walkwayBE : updateSecondPass) {
            walkwayBE.visualProgress = this.visualProgress;
            walkwayBE.setWalkwayWidth(actualWidth);
            walkwayBE.widthReferencePos = this.widthReferencePos;
            walkwayBE.updateCount = 1;
        }
    }

    public float calculateStressApplied() {
        return this.isController() ? super.calculateStressApplied() : 0.0f;
    }

    public AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().inflate(1.0);
    }

    public void clearKineticInformation() {
        super.clearKineticInformation();
        this.walkwayLength = 0;
        this.controller = null;
    }

    public WalkwayBlockEntity getControllerBE() {
        WalkwayBlockEntity walkway;
        BlockEntity blockEntity;
        if (this.controller == null || !this.level.isLoaded(this.controller)) {
            return null;
        }
        return this.controller != null && this.level.isLoaded(this.controller) && (blockEntity = this.level.getBlockEntity(this.controller)) instanceof WalkwayBlockEntity ? (walkway = (WalkwayBlockEntity)blockEntity) : null;
    }

    public void setController(BlockPos controller) {
        this.controller = controller;
    }

    public BlockPos getController() {
        return this.controller == null ? this.worldPosition : this.controller;
    }

    public boolean isController() {
        return this.controller != null && this.worldPosition.getX() == this.controller.getX() && this.worldPosition.getY() == this.controller.getY() && this.worldPosition.getZ() == this.controller.getZ();
    }

    public int getWalkwayWidth() {
        WalkwayBlockEntity controller = this.getControllerBE();
        return controller == null ? 1 : controller.walkwayWidth;
    }

    public void setWalkwayWidth(int width) {
        WalkwayBlockEntity controller = this.getControllerBE();
        if (controller != null) {
            controller.walkwayWidth = width;
        }
    }

    public boolean isEscalator() {
        Block block = this.getBlockState().getBlock();
        if (!(block instanceof WalkwayBlock)) {
            return false;
        }
        WalkwayBlock walkwayBlock = (WalkwayBlock)block;
        WalkwaySlope slope = walkwayBlock.getWalkwaySlope(this.getBlockState());
        return slope != WalkwaySlope.HORIZONTAL && slope != WalkwaySlope.TERMINAL;
    }

    public List<BlockPos> getAllBlocks() {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        WalkwayBlockEntity controller = this.getControllerBE();
        if (controller == null) {
            return list;
        }
        BlockPos current = controller.getBlockPos();
        boolean terminal = false;
        for (int i = 0; i < this.walkwayLength; ++i) {
            list.add(current);
            BlockState state = this.level.getBlockState(current);
            if (!(state.getBlock() instanceof WalkwayBlock)) {
                return new ArrayList<BlockPos>();
            }
            BlockPos nextPos = WalkwayBlock.nextSegmentPosition(state, current, !terminal, terminal);
            terminal = true;
            if (nextPos == null) break;
            current = nextPos;
        }
        return list;
    }

    protected boolean canPropagateDiagonally(IRotate block, BlockState state) {
        return super.canPropagateDiagonally(block, state) || this.isEscalator();
    }

    public float propagateRotationTo(KineticBlockEntity target, BlockState stateFrom, BlockState stateTo, BlockPos diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        if (target instanceof WalkwayBlockEntity) {
            WalkwayBlockEntity walkway = (WalkwayBlockEntity)target;
            if (!connectedViaAxes) {
                return this.getController().equals((Object)walkway.getController()) ? 1.0f : 0.0f;
            }
        }
        return 0.0f;
    }

    public float getWalkwayMovementSpeed() {
        return this.getSpeed() / 480.0f;
    }

    public float getVisualProgress() {
        WalkwayBlockEntity controller = this.getControllerBE();
        return controller == null ? 0.0f : controller.visualProgress;
    }

    public void setVisualProgress(float visualProgress) {
        this.visualProgress = visualProgress;
    }

    public boolean applyColor(@Nullable DyeColor colorIn) {
        if (colorIn == this.color) {
            return false;
        }
        if (this.level.isClientSide) {
            return true;
        }
        int WIDTH_LIMIT = 256;
        Direction facing = ((WalkwayBlock)this.getBlockState().getBlock()).getFacing(this.getBlockState());
        Direction left = facing.getCounterClockWise();
        List<BlockPos> walkwayChain = WalkwayBlock.getWalkwayChain(this.level, this.getController());
        for (BlockPos pos : walkwayChain) {
            block1: for (Direction dir : Iterate.directionsInAxis((Direction.Axis)left.getAxis())) {
                for (int i = 0; i < WIDTH_LIMIT; ++i) {
                    WalkwayBlock walkwayBlock;
                    BlockState currentState;
                    Block block;
                    BlockPos currentPos = pos.relative(dir, i);
                    WalkwayBlockEntity walkway = WalkwayHelper.getSegmentBE((LevelAccessor)this.level, currentPos);
                    if (walkway != null) {
                        walkway.color = colorIn;
                        walkway.notifyUpdate();
                    }
                    if (!((block = (currentState = this.level.getBlockState(currentPos)).getBlock()) instanceof WalkwayBlock) || !(walkwayBlock = (WalkwayBlock)block).connectedToWalkwayOnSide(this.level, currentState, currentPos, dir)) continue block1;
                }
            }
        }
        return true;
    }

    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        if (this.controller != null) {
            compound.put("Controller", NbtUtils.writeBlockPos((BlockPos)this.controller));
        }
        compound.putBoolean("IsController", this.isController());
        compound.putInt("Length", this.walkwayLength);
        if (this.isController()) {
            compound.putFloat("VisualProgress", this.visualProgress);
            compound.putInt("Width", this.walkwayWidth);
            if (this.widthReferencePos != null) {
                compound.put("WidthReferencePos", NbtUtils.writeBlockPos((BlockPos)this.widthReferencePos));
            }
        }
        if (this.color != null) {
            NBTHelper.writeEnum((CompoundTag)compound, (String)"Dye", (Enum)this.color);
        }
        super.write(compound, registries, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (this.resetClientRender) {
            compound.putBoolean("UpdateRendering", false);
        }
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        if (compound.getBoolean("IsController")) {
            this.controller = this.worldPosition;
            this.visualProgress = compound.getFloat("VisualProgress");
            this.walkwayWidth = compound.getInt("Width");
            this.widthReferencePos = NbtUtils.readBlockPos((CompoundTag)compound, (String)"WidthReferencePos").orElse(this.getBlockPos());
        }
        DyeColor dyeColor = this.color = compound.contains("Dye", 8) ? (DyeColor)NBTHelper.readEnum((CompoundTag)compound, (String)"Dye", DyeColor.class) : null;
        if (!this.wasMoved) {
            if (!this.isController()) {
                this.controller = NbtUtils.readBlockPos((CompoundTag)compound, (String)"Controller").orElse(null);
            }
            this.walkwayLength = compound.getInt("Length");
        }
        if (!clientPacket) {
            return;
        }
        if (this.isController()) {
            this.lazyResetClientRender = true;
            float speed = this.getWalkwayMovementSpeed();
            this.visualProgress += speed;
            if (Math.abs(this.visualProgress) > 0.5f) {
                this.visualProgress = Math.signum(this.visualProgress) * (Math.abs(this.visualProgress) % 0.5f);
            }
        }
        this.resetClientRender |= compound.contains("UpdateRendering");
    }

    public void writeSafe(CompoundTag tag, HolderLookup.Provider registries) {
        super.writeSafe(tag, registries);
        if (this.color != null) {
            NBTHelper.writeEnum((CompoundTag)tag, (String)"Dye", (Enum)this.color);
        }
    }
}

