/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.walkways;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import rbasamoyai.escalated.index.EscalatedShapes;
import rbasamoyai.escalated.walkways.AbstractWalkwayBlock;
import rbasamoyai.escalated.walkways.WalkwayCaps;
import rbasamoyai.escalated.walkways.WalkwaySet;
import rbasamoyai.escalated.walkways.WalkwaySlope;
import rbasamoyai.escalated.walkways.WideWalkwaySideBlock;

public class NarrowWalkwayBlock
extends AbstractWalkwayBlock {
    public NarrowWalkwayBlock(BlockBehaviour.Properties properties, NonNullSupplier<WalkwaySet> walkwaySetSupplier) {
        super(properties, walkwaySetSupplier);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)CAPS, (Comparable)((Object)WalkwayCaps.NO_SHAFT)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{CAPS});
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        Direction leftFace = ((Direction)state.getValue(HORIZONTAL_FACING)).getCounterClockWise();
        WalkwayCaps caps = (WalkwayCaps)((Object)state.getValue((Property)CAPS));
        return face == leftFace && !caps.hasLeftCap() || face == leftFace.getOpposite() && !caps.hasRightCap();
    }

    protected boolean areStatesKineticallyEquivalent(BlockState oldState, BlockState newState) {
        return super.areStatesKineticallyEquivalent(oldState, newState) && oldState.getValue((Property)CAPS) == newState.getValue((Property)CAPS);
    }

    @Override
    public WalkwaySlope getWalkwaySlope(BlockState state) {
        return WalkwaySlope.HORIZONTAL;
    }

    @Override
    public boolean hasWalkwayShaft(BlockState state) {
        return state.getValue((Property)CAPS) != WalkwayCaps.NO_SHAFT;
    }

    @Override
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player.isShiftKeyDown() || !player.mayBuild()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (AllBlocks.SHAFT.isIn(stack)) {
            if (state.getValue((Property)CAPS) != WalkwayCaps.NO_SHAFT) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            if (level.isClientSide) {
                return ItemInteractionResult.SUCCESS;
            }
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)pos, (BlockState)((BlockState)state.setValue((Property)CAPS, (Comparable)((Object)WalkwayCaps.NONE))));
            ((ShaftBlock)AllBlocks.SHAFT.get()).playEncaseSound(level, pos);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Level level = context.getLevel();
        BlockState newState = state;
        Direction facing = (Direction)state.getValue(HORIZONTAL_FACING);
        Direction left = facing.getCounterClockWise();
        Direction right = left.getOpposite();
        Direction clicked = context.getClickedFace();
        WalkwayCaps caps = (WalkwayCaps)((Object)state.getValue((Property)CAPS));
        if (caps == WalkwayCaps.NO_SHAFT) {
            return InteractionResult.PASS;
        }
        if (clicked == left) {
            caps = caps.toggleLeft();
        }
        if (clicked == right) {
            caps = caps.toggleRight();
        }
        newState = (BlockState)newState.setValue((Property)CAPS, (Comparable)((Object)caps));
        KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)context.getClickedPos(), (BlockState)this.updateAfterWrenched(newState, context));
        BlockState setState = level.getBlockState(context.getClickedPos());
        if (setState != state) {
            AllSoundEvents.WRENCH_REMOVE.playOnServer(level, (Vec3i)context.getClickedPos(), 1.0f, level.random.nextFloat() * 0.5f + 0.5f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        if (state.getValue((Property)CAPS) != WalkwayCaps.NO_SHAFT) {
            if (level.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            if (player != null && !player.isCreative()) {
                player.getInventory().placeItemBackInInventory(AllBlocks.SHAFT.asStack());
            }
            KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)pos, (BlockState)((BlockState)state.setValue((Property)CAPS, (Comparable)((Object)WalkwayCaps.NO_SHAFT))));
            AllSoundEvents.WRENCH_REMOVE.playOnServer(level, (Vec3i)pos, 1.0f, level.random.nextFloat() * 0.5f + 0.5f);
            return InteractionResult.SUCCESS;
        }
        return super.onSneakWrenched(state, context);
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return EscalatedShapes.NARROW_WALKWAY.get((Direction)state.getValue(HORIZONTAL_FACING));
    }

    @Override
    public BlockState transformFromMerge(Level level, BlockState state, BlockPos pos, boolean left, boolean shaft, boolean remove, boolean replace) {
        if (remove) {
            return state;
        }
        WalkwayCaps caps = shaft ? WalkwayCaps.NONE : WalkwayCaps.NO_SHAFT;
        WalkwayCaps srcCaps = (WalkwayCaps)((Object)state.getValue((Property)CAPS));
        if (shaft && (srcCaps.hasRightCap() && left || srcCaps.hasLeftCap() && !left)) {
            caps = WalkwayCaps.BOTH;
        }
        return (BlockState)((BlockState)((BlockState)this.getWalkwaySet().getWideSideBlock(level, state, pos).setValue(HORIZONTAL_FACING, (Comparable)((Direction)state.getValue(HORIZONTAL_FACING)))).setValue((Property)WideWalkwaySideBlock.CAPS_SIDED, (Comparable)((Object)caps))).setValue((Property)WideWalkwaySideBlock.LEFT, (Comparable)Boolean.valueOf(!left));
    }

    @Override
    public boolean connectedToWalkwayOnSide(Level level, BlockState state, BlockPos pos, Direction face) {
        return face.getAxis() == ((Direction)state.getValue(HORIZONTAL_FACING)).getAxis();
    }

    @Override
    public boolean isEscalator(Level level, BlockState state, BlockPos pos) {
        return false;
    }
}

