/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.handrails;

import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import java.util.Locale;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import rbasamoyai.escalated.handrails.HandrailBlockEntity;
import rbasamoyai.escalated.index.EscalatedBlockEntities;
import rbasamoyai.escalated.walkways.WalkwayHelper;
import rbasamoyai.escalated.walkways.WalkwaySlope;

public abstract class AbstractHandrailBlock
extends HorizontalDirectionalBlock
implements IBE<HandrailBlockEntity>,
ProperWaterloggedBlock {
    public static final EnumProperty<Side> SIDE = EnumProperty.create((String)"side", Side.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    protected AbstractHandrailBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, SIDE, WATERLOGGED});
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        int width = 1;
        boolean propagateBreak = true;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof HandrailBlockEntity) {
            HandrailBlockEntity handrailBlockEntity = (HandrailBlockEntity)blockEntity;
            width = handrailBlockEntity.width;
            propagateBreak = handrailBlockEntity.propagateBreak;
        }
        super.onRemove(state, level, pos, newState, isMoving);
        if (level.isClientSide || !propagateBreak || state.getBlock() == newState.getBlock() || isMoving) {
            return;
        }
        for (boolean forward : Iterate.trueAndFalse) {
            BlockState otherState;
            BlockPos otherPos = AbstractHandrailBlock.nextSegmentPosition(state, pos, forward);
            if (otherPos == null || !((otherState = level.getBlockState(otherPos)).getBlock() instanceof AbstractHandrailBlock)) continue;
            BlockEntity blockEntity2 = level.getBlockEntity(otherPos);
            if (blockEntity2 instanceof HandrailBlockEntity) {
                HandrailBlockEntity handrailBE = (HandrailBlockEntity)blockEntity2;
                handrailBE.width = width;
            }
            level.setBlock(otherPos, ProperWaterloggedBlock.withWater((LevelAccessor)level, (BlockState)Blocks.AIR.defaultBlockState(), (BlockPos)otherPos), 3);
            level.levelEvent(2001, otherPos, Block.getId((BlockState)otherState));
        }
        Side side = (Side)((Object)state.getValue(SIDE));
        if (side != Side.BOTH && width > 1) {
            Direction dir = (Direction)state.getValue((Property)FACING);
            Direction checkDir = side == Side.LEFT ? dir.getClockWise() : dir.getCounterClockWise();
            BlockPos otherPos = pos.relative(checkDir, width - 1);
            BlockEntity blockEntity3 = level.getBlockEntity(otherPos);
            if (blockEntity3 instanceof HandrailBlockEntity) {
                HandrailBlockEntity handrailBE = (HandrailBlockEntity)blockEntity3;
                handrailBE.width = 0;
            }
            level.setBlock(otherPos, ProperWaterloggedBlock.withWater((LevelAccessor)level, (BlockState)Blocks.AIR.defaultBlockState(), (BlockPos)otherPos), 3);
            level.levelEvent(2001, otherPos, Block.getId((BlockState)level.getBlockState(otherPos)));
        }
    }

    public abstract BlockState getStateForSlope(Level var1, BlockPos var2, BlockState var3, BlockPos var4, Direction var5, WalkwaySlope var6, Side var7);

    public Class<HandrailBlockEntity> getBlockEntityClass() {
        return HandrailBlockEntity.class;
    }

    public BlockEntityType<? extends HandrailBlockEntity> getBlockEntityType() {
        return (BlockEntityType)EscalatedBlockEntities.HANDRAIL.get();
    }

    public abstract WalkwaySlope getHandrailSlope(BlockState var1);

    public abstract boolean isEndHandrail(BlockState var1);

    public FluidState getFluidState(BlockState blockState) {
        return this.fluidState(blockState);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player.isShiftKeyDown() || !player.mayBuild()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        boolean isDye = WalkwayHelper.isDye(stack);
        boolean hasWater = WalkwayHelper.hasWater(level, stack);
        if (isDye || hasWater) {
            return this.onBlockEntityUseItemOn((BlockGetter)level, pos, be -> be.setHandrailColor(WalkwayHelper.getDyeColorFromItem(stack)) ? ItemInteractionResult.SUCCESS : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION);
        }
        boolean isGlass = stack.is(Blocks.GLASS.asItem());
        if (isGlass && this.canConvertToGlassHandrail()) {
            this.convertToGlass(state, level, pos);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected void convertToGlass(BlockState state, Level level, BlockPos pos) {
        Direction direction;
        BlockPos offsetPos;
        BlockEntity blockEntity;
        HandrailBlockEntity handrailBE;
        if (level.isClientSide) {
            return;
        }
        int MAX_ITER = 1100;
        Direction facing = (Direction)state.getValue((Property)FACING);
        Direction left = facing.getCounterClockWise();
        Side side = (Side)((Object)state.getValue(SIDE));
        int width = 1;
        DyeColor color = null;
        BlockEntity blockEntity2 = level.getBlockEntity(pos);
        if (blockEntity2 instanceof HandrailBlockEntity) {
            handrailBE = (HandrailBlockEntity)blockEntity2;
            width = handrailBE.width;
            color = handrailBE.getHandrailColor();
            handrailBE.propagateBreak = false;
        }
        level.setBlock(pos, this.getGlassHandrail(state), 3);
        BlockEntity blockEntity3 = level.getBlockEntity(pos);
        if (blockEntity3 instanceof HandrailBlockEntity) {
            handrailBE = (HandrailBlockEntity)blockEntity3;
            handrailBE.width = width;
        }
        BlockPos offset = BlockPos.ZERO;
        if (width > 1 && (blockEntity = level.getBlockEntity(offsetPos = pos.offset((Vec3i)(offset = BlockPos.ZERO.relative(direction = side == Side.LEFT ? left.getOpposite() : left, width - 1))))) instanceof HandrailBlockEntity) {
            HandrailBlockEntity handrailBE2 = (HandrailBlockEntity)blockEntity;
            handrailBE2.propagateBreak = false;
            level.setBlock(offsetPos, this.getGlassHandrail(level.getBlockState(offsetPos)), 3);
            BlockEntity blockEntity4 = level.getBlockEntity(offsetPos);
            if (blockEntity4 instanceof HandrailBlockEntity) {
                HandrailBlockEntity handrailBE1 = (HandrailBlockEntity)blockEntity4;
                handrailBE1.width = width;
            }
        }
        for (boolean forward : Iterate.trueAndFalse) {
            BlockPos iterPos = pos;
            BlockState iterState = state;
            for (int i = 0; i < MAX_ITER && (iterPos = AbstractHandrailBlock.nextSegmentPosition(iterState, iterPos, forward)) != null && (iterState = level.getBlockState(iterPos)).getBlock() instanceof AbstractHandrailBlock; ++i) {
                BlockEntity blockEntity5;
                BlockEntity blockEntity6 = level.getBlockEntity(iterPos);
                if (blockEntity6 instanceof HandrailBlockEntity) {
                    HandrailBlockEntity other = (HandrailBlockEntity)blockEntity6;
                    other.propagateBreak = false;
                    level.setBlock(iterPos, this.getGlassHandrail(iterState), 3);
                    blockEntity5 = level.getBlockEntity(iterPos);
                    if (blockEntity5 instanceof HandrailBlockEntity) {
                        HandrailBlockEntity other1 = (HandrailBlockEntity)blockEntity5;
                        other1.width = width;
                    }
                }
                BlockPos offsetPos2 = iterPos.offset((Vec3i)offset);
                if (width <= 1 || !((blockEntity5 = level.getBlockEntity(offsetPos2)) instanceof HandrailBlockEntity)) continue;
                HandrailBlockEntity other = (HandrailBlockEntity)blockEntity5;
                other.propagateBreak = false;
                level.setBlock(offsetPos2, this.getGlassHandrail(level.getBlockState(offsetPos2)), 3);
                BlockEntity blockEntity7 = level.getBlockEntity(offsetPos2);
                if (!(blockEntity7 instanceof HandrailBlockEntity)) continue;
                HandrailBlockEntity other1 = (HandrailBlockEntity)blockEntity7;
                other1.width = width;
            }
        }
        BlockEntity blockEntity8 = level.getBlockEntity(pos);
        if (blockEntity8 instanceof HandrailBlockEntity) {
            HandrailBlockEntity handrailBlockEntity = (HandrailBlockEntity)blockEntity8;
            handrailBlockEntity.setHandrailColor(color);
        }
    }

    protected abstract boolean canConvertToGlassHandrail();

    protected abstract BlockState getGlassHandrail(BlockState var1);

    public static BlockPos nextSegmentPosition(BlockState state, BlockPos pos, boolean forward) {
        int offset;
        AbstractHandrailBlock handrail = (AbstractHandrailBlock)state.getBlock();
        Direction direction = (Direction)state.getValue((Property)FACING);
        WalkwaySlope slope = handrail.getHandrailSlope(state);
        boolean isEnd = handrail.isEndHandrail(state);
        int n = offset = forward ? 1 : -1;
        if (slope == WalkwaySlope.TERMINAL && isEnd == forward) {
            return null;
        }
        pos = pos.relative(direction, offset);
        if (slope == WalkwaySlope.MIDDLE) {
            return pos.above(offset);
        }
        if (slope == WalkwaySlope.TOP && !forward) {
            return pos.below();
        }
        if (slope == WalkwaySlope.BOTTOM && forward) {
            return pos.above();
        }
        return pos;
    }

    public static enum Side implements StringRepresentable
    {
        LEFT,
        RIGHT,
        BOTH;

        private final String id = this.name().toLowerCase(Locale.ROOT);

        public String getSerializedName() {
            return this.id;
        }
    }
}

