/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.datagen.provider.client;

import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.BlockItem;
import net.neoforged.neoforge.common.data.LanguageProvider;
import org.codehaus.plexus.util.StringUtils;
import tech.alexnijjar.endermanoverhaul.common.constants.ConstantComponents;
import tech.alexnijjar.endermanoverhaul.common.registry.ModBlocks;
import tech.alexnijjar.endermanoverhaul.common.registry.ModEntityTypes;
import tech.alexnijjar.endermanoverhaul.common.registry.ModItems;

public class ModLangProvider
extends LanguageProvider {
    public ModLangProvider(PackOutput output) {
        super(output, "endermanoverhaul", "en_us");
    }

    protected void addTranslations() {
        ModBlocks.BLOCKS.stream().forEach(entry -> this.addBlock((Supplier)entry, StringUtils.capitaliseAllWords((String)entry.getId().getPath().replace("_", " "))));
        ModItems.ITEMS.stream().filter(i -> !(i.get() instanceof BlockItem)).forEach(entry -> this.addItem((Supplier)entry, StringUtils.capitaliseAllWords((String)entry.getId().getPath().replace("_", " "))));
        ModEntityTypes.ENTITY_TYPES.stream().forEach(entry -> this.addEntityType((Supplier)entry, StringUtils.capitaliseAllWords((String)entry.getId().getPath().replace("_", " "))));
        this.add("itemGroup.endermanoverhaul.main", "Enderman Overhaul");
        this.add(ConstantComponents.CORRUPTED_PEARL_TOOLTIP.getString(), "Teleports targets to a random location");
        this.add(ConstantComponents.SOUL_PEARL_TOOLTIP_1.getString(), "Crouch-right-click to bind an entity");
        this.add(ConstantComponents.SOUL_PEARL_TOOLTIP_2.getString(), "Teleports the bound entity to the target location");
        this.add(ConstantComponents.ANCIENT_PEARL_TOOLTIP.getString(), "Summons a friendly enderman to fight for you");
        this.add(ConstantComponents.BUBBLE_PEARL_TOOLTIP.getString(), "Accurate Ender Pearl with no gravity");
        this.add(ConstantComponents.ICY_PEARL_TOOLTIP.getString(), "Freezes nearby targets on hit");
        this.add(ConstantComponents.SUMMONER_PEARL_TOOLTIP.getString(), "Teleports nearby targets on hit");
        this.add(ConstantComponents.CRIMSON_PEARL_TOOLTIP.getString(), "Applies Strength II when teleporting");
        this.add(ConstantComponents.WARPED_PEARL_TOOLTIP.getString(), "Applies Resistance II when teleporting");
        this.add(ConstantComponents.HOOD_TOOLTIP.getString(), "Allows you to look at endermen without angering them");
        this.add(ConstantComponents.CORRUPTED_BLADE_TOOLTIP.getString(), "Teleports targets randomly");
        this.add(ConstantComponents.CORRUPTED_SHIELD_TOOLTIP.getString(), "Teleports attackers randomly");
        this.add("tooltip.endermanoverhaul.bound_to", "Bound to: %s");
        this.add("tooltip.endermanoverhaul.ancient_pet", "Pet health: %.1f");
        this.add(ConstantComponents.NOT_BOUND.getString(), "Not bound");
        this.add("tag.item.endermanoverhaul.ender_pearls", "Ender Pearls");
        this.add("subtitles.endermanoverhaul.entity.cave_enderman.ambient", "Cave Enderman vwoops");
        this.add("subtitles.endermanoverhaul.entity.cave_enderman.hurt", "Cave Enderman hurts");
        this.add("subtitles.endermanoverhaul.entity.plant_enderman.ambient", "Plant Enderman vwoops");
        this.add("subtitles.endermanoverhaul.entity.plant_enderman.hurt", "Plant Enderman hurts");
        this.add("subtitles.endermanoverhaul.entity.tall_enderman.ambient", "Tall Enderman vwoops");
        this.add("subtitles.endermanoverhaul.entity.tall_enderman.death", "Tall Enderman dies");
        this.add("subtitles.endermanoverhaul.entity.tall_enderman.stare", "Tall Enderman cries out");
        this.add("subtitles.endermanoverhaul.entity.dark_oak_enderman.ambient", "Dark Oak Enderman vwoops");
        this.add("subtitles.endermanoverhaul.entity.dark_oak_enderman.darkness", "Dark Oak Enderman darkens");
        this.add("subtitles.endermanoverhaul.entity.dark_oak_enderman.stare", "Dark Oak Enderman cries out");
        this.add("subtitles.endermanoverhaul.entity.ancient_pearl.hit", "Ancient Pearl Hits");
        this.add("subtitles.endermanoverhaul.entity.bubble_pearl.hit", "Bubble Pearl Pops");
        this.add("subtitles.endermanoverhaul.entity.bubble_pearl.thrown", "Bubble Pearl Thrown");
        this.add("subtitles.endermanoverhaul.entity.corrupted_pearl.hit", "Corrupted Pearl Hits");
        this.add("subtitles.endermanoverhaul.entity.soul_pearl.hit", "Soul Pearl Hits");
        this.add("subtitles.endermanoverhaul.entity.summoner_pearl.hit", "Summoner Pearl Hits");
        this.add("subtitles.endermanoverhaul.entity.icy_pearl.hit", "Icy Pearl Hits");
        this.add("config.endermanoverhaul.title", "Enderman Overhaul");
        this.add("config.endermanoverhaul.client.title", "Enderman Overhaul Client");
        this.add("config.endermanoverhaul.description", "Enderman overhaul adds biome-specific Enderman!");
        this.add("config.endermanoverhaul.clientConfig", "Client Config");
        this.add("config.endermanoverhaul.allowPickingUpBlocks", "Allow Picking Up Blocks");
        this.add("config.endermanoverhaul.friendlyEndermanTeleport", "Friendly Enderman Teleport");
        this.add("config.endermanoverhaul.friendlyEndermanDespawn", "Friendly Enderman Despawn");
        this.add("config.endermanoverhaul.replaceDefaultEnderman", "Replace Default Enderman");
        this.add("config.endermanoverhaul.replaceMekanismBabyEnderman", "Replace Mekanism Baby Enderman");
        this.add("config.endermanoverhaul.flashScreen", "Flash Screen");
        this.add("config.endermanoverhaul.allowSpawning", "Allow Spawning");
        this.add("config.endermanoverhaul.spawnBadlandsEnderman", "Spawn Badlands Enderman");
        this.add("config.endermanoverhaul.spawnCaveEnderman", "Spawn Cave Enderman");
        this.add("config.endermanoverhaul.spawnCrimsonForestEnderman", "Spawn Crimson Forest Enderman");
        this.add("config.endermanoverhaul.spawnDarkOakEnderman", "Spawn Dark Oak Enderman");
        this.add("config.endermanoverhaul.spawnDesertEnderman", "Spawn Desert Enderman");
        this.add("config.endermanoverhaul.spawnEndEnderman", "Spawn End Enderman");
        this.add("config.endermanoverhaul.spawnEndIslandsEnderman", "Spawn End Islands Enderman");
        this.add("config.endermanoverhaul.spawnFlowerFieldsEnderman", "Spawn Flower Fields Enderman");
        this.add("config.endermanoverhaul.spawnIceSpikesEnderman", "Spawn Ice Spikes Enderman");
        this.add("config.endermanoverhaul.spawnMushroomFieldsEnderman", "Spawn Mushroom Fields Enderman");
        this.add("config.endermanoverhaul.spawnNetherWastesEnderman", "Spawn Nether Wastes Enderman");
        this.add("config.endermanoverhaul.spawnCoralEnderman", "Spawn Coral Enderman");
        this.add("config.endermanoverhaul.spawnSavannaEnderman", "Spawn Savanna Enderman");
        this.add("config.endermanoverhaul.spawnSnowyEnderman", "Spawn Snowy Enderman");
        this.add("config.endermanoverhaul.spawnSoulsandValleyEnderman", "Spawn Soulsand Valley Enderman");
        this.add("config.endermanoverhaul.spawnSwampEnderman", "Spawn Swamp Enderman");
        this.add("config.endermanoverhaul.spawnWarpedForestEnderman", "Spawn Warped Forest Enderman");
        this.add("config.endermanoverhaul.spawnWindsweptHillsEnderman", "Spawn Windswept Hills Enderman");
        this.add("config.endermanoverhaul.endEndermanTeleportChance", "End Enderman Teleport Chance");
    }
}

