/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.client.config.info;

import com.teamresourceful.resourcefulconfig.api.types.info.ResourcefulConfigLink;
import com.teamresourceful.resourcefulconfig.api.types.options.TranslatableValue;
import org.intellij.lang.annotations.Subst;

public class EndermanOverhaulConfigLinks {
    public static final ResourcefulConfigLink GITHUB = EndermanOverhaulConfigLinks.create(Type.GITHUB, "https://github.com/bonsaistudi0s/enderman-overhaul");
    public static final ResourcefulConfigLink DISCORD = EndermanOverhaulConfigLinks.create(Type.DISCORD, "https://discord.gg/sGwxnFV");
    public static final ResourcefulConfigLink MODRINTH = EndermanOverhaulConfigLinks.create(Type.MODRINTH, "https://modrinth.com/mod/enderman-overhaul");
    public static final ResourcefulConfigLink CURSEFORGE = EndermanOverhaulConfigLinks.create(Type.CURSEFORGE, "https://www.curseforge.com/minecraft/mc-mods/enderman-overhaul");
    public static final ResourcefulConfigLink[] LINKS = new ResourcefulConfigLink[]{DISCORD, GITHUB, MODRINTH, CURSEFORGE};

    private static ResourcefulConfigLink create(Type type, @Subst(value="https://example.com") String url) {
        return ResourcefulConfigLink.create((String)url, (String)type.icon(), (TranslatableValue)type.text());
    }

    private static enum Type {
        GITHUB,
        DISCORD,
        MODRINTH,
        CURSEFORGE;


        public String icon() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "github";
                case 1 -> "gamepad-2";
                case 2 -> "modrinth";
                case 3 -> "curseforge";
            };
        }

        public TranslatableValue text() {
            return new TranslatableValue(switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "GitHub";
                case 1 -> "Discord";
                case 2 -> "Modrinth";
                case 3 -> "CurseForge";
            }, switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "config.ad_astra.links.github";
                case 1 -> "config.ad_astra.links.discord";
                case 2 -> "config.ad_astra.links.modrinth";
                case 3 -> "config.ad_astra.links.curseforge";
            });
        }
    }
}

