/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.mixin;

import dev.emi.emi.platform.EmiClient;
import dev.emi.emi.runtime.EmiLog;
import dev.emi.emi.runtime.EmiReloadManager;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Coerce;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Minecraft.class})
public class MinecraftClientMixin {
    @Shadow
    public ClientLevel level;

    @Inject(at={@At(value="RETURN")}, method={"reloadResourcePacks(ZLnet/minecraft/client/Minecraft$GameLoadCookie;)Ljava/util/concurrent/CompletableFuture;"})
    private void reloadResources(boolean force, @Coerce Object loadingContext, CallbackInfoReturnable<CompletableFuture<Void>> info) {
        CompletableFuture future = (CompletableFuture)info.getReturnValue();
        if (future != null) {
            future.thenRunAsync(() -> {
                Minecraft client = Minecraft.getInstance();
                if (client.level != null && client.level.getRecipeManager() != null) {
                    EmiReloadManager.reload();
                }
            }, Executors.newFixedThreadPool(1));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"disconnect(Lnet/minecraft/client/gui/screens/Screen;)V"})
    private void disconnect(CallbackInfo info) {
        EmiLog.info("Disconnecting from server, EMI data cleared");
        EmiReloadManager.clear();
        EmiClient.onServer = false;
    }
}

