/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.world.features;

import com.kyanite.deeperdarker.content.DDBlocks;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class SculkStoneColumnFeature
extends Feature<NoneFeatureConfiguration> {
    public SculkStoneColumnFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos origin = context.origin();
        RandomSource random = context.random();
        int columnHeight = 0;
        BlockPos.MutableBlockPos blockPos = origin.mutable();
        while (level.getBlockState((BlockPos)blockPos).isAir()) {
            ++columnHeight;
            blockPos.move(0, 1, 0);
        }
        if (this.anyObstruction(level, origin, columnHeight)) {
            return false;
        }
        if (!level.getBlockState(origin.below()).is(Blocks.SCULK)) {
            return false;
        }
        level.setBlock(origin.below(), ((Block)DDBlocks.SCULK_STONE.get()).defaultBlockState(), 3);
        level.setBlock(origin.above(columnHeight), ((Block)DDBlocks.SCULK_STONE.get()).defaultBlockState(), 3);
        blockPos = origin.mutable();
        for (int i = 1; i < columnHeight + 1; ++i) {
            level.setBlock((BlockPos)blockPos, ((Block)DDBlocks.SCULK_STONE.get()).defaultBlockState(), 3);
            blockPos.move(0, 1, 0);
        }
        double multiplier = (float)columnHeight * 0.35f < 7.0f ? 1.2 : 1.0;
        this.columnBase(level, random, origin, columnHeight, multiplier, true);
        this.columnBase(level, random, origin.above(columnHeight - 1), columnHeight, multiplier, false);
        return true;
    }

    private boolean anyObstruction(WorldGenLevel level, BlockPos pos, int distance) {
        for (int i = 0; i < distance; ++i) {
            if (level.getBlockState(pos.above(i)).is(Blocks.AIR)) continue;
            return true;
        }
        return false;
    }

    private void columnBase(WorldGenLevel level, RandomSource random, BlockPos origin, int columnHeight, double multiplier, boolean bottom) {
        int i;
        for (i = 0; i < 4; ++i) {
            int baseHeight = random.nextInt((int)(0.36 * (double)columnHeight * multiplier), (int)(0.41 * (double)columnHeight * multiplier) + 1);
            this.placeSection(level, random, origin, baseHeight, i, 1, multiplier, bottom);
            this.stretchToFloor(level, origin, i, 1, bottom);
        }
        for (i = 0; i < 8; ++i) {
            double baseHeight = random.nextInt((int)(0.22 * (double)columnHeight), (int)(0.26 * (double)columnHeight) + 1);
            if (i > 3) {
                baseHeight *= 0.67;
            }
            this.placeSection(level, random, origin, baseHeight, i, 2, multiplier, bottom);
            this.stretchToFloor(level, origin, i, 2, bottom);
        }
        if (multiplier > 1.0) {
            return;
        }
        for (i = 0; i < 8; ++i) {
            int baseHeight = random.nextInt((int)(0.04 * (double)columnHeight), (int)(0.08 * (double)columnHeight) + 1);
            this.placeSection(level, random, origin, baseHeight, i, 3, multiplier, bottom);
            this.stretchToFloor(level, origin, i, 3, bottom);
        }
    }

    private void placeSection(WorldGenLevel level, RandomSource random, BlockPos pos, double baseHeight, int iteration, int loop, double multiplier, boolean bottom) {
        float p = random.nextFloat();
        int j = 0;
        while ((double)j < baseHeight) {
            BlockPos location = this.spread(bottom ? pos.above(j) : pos.below(j), iteration, loop);
            if (iteration > 3 && multiplier > 1.0) {
                return;
            }
            if ((double)j == baseHeight - 2.0 && j != 0 && p < 0.1f) {
                level.setBlock(location, Blocks.SCULK.defaultBlockState(), 3);
            } else if ((double)j == baseHeight - 1.0 && j != 0 && p < 0.22f) {
                level.setBlock(location, Blocks.SCULK.defaultBlockState(), 3);
            } else {
                level.setBlock(location, ((Block)DDBlocks.SCULK_STONE.get()).defaultBlockState(), 3);
            }
            ++j;
        }
    }

    private BlockPos spread(BlockPos pos, int index, int loop) {
        BlockPos basePos = pos;
        block5: for (int i = 0; i < loop; ++i) {
            int j = i % 2;
            if (index > 3 && loop == 2 && i == 0) {
                ++j;
            } else if (index > 3 && i != 1) {
                j += 2;
            }
            switch ((index + j) % 4) {
                default: {
                    basePos = basePos.north();
                    continue block5;
                }
                case 1: {
                    basePos = basePos.east();
                    continue block5;
                }
                case 2: {
                    basePos = basePos.south();
                    continue block5;
                }
                case 3: {
                    basePos = basePos.west();
                }
            }
        }
        return basePos;
    }

    private void stretchToFloor(WorldGenLevel level, BlockPos pos, int i, int loop, boolean bottom) {
        BlockPos blockPos = this.spread(bottom ? pos.below() : pos.above(), i, loop);
        if (bottom) {
            while (!(level.getBlockState(blockPos).is((Block)DDBlocks.SCULK_STONE.get()) || level.getBlockState(blockPos).is(Blocks.DEEPSLATE) || level.isOutsideBuildHeight(blockPos))) {
                level.setBlock(blockPos, ((Block)DDBlocks.SCULK_STONE.get()).defaultBlockState(), 3);
                blockPos = blockPos.below();
            }
            return;
        }
        while (!(level.getBlockState(blockPos).is(Blocks.SCULK) || level.getBlockState(blockPos).is((Block)DDBlocks.SCULK_STONE.get()) || level.getBlockState(blockPos).is(Blocks.DEEPSLATE) || level.isOutsideBuildHeight(blockPos))) {
            level.setBlock(blockPos, ((Block)DDBlocks.SCULK_STONE.get()).defaultBlockState(), 3);
            blockPos = blockPos.above();
        }
    }
}

