/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.content.entities;

import com.kyanite.deeperdarker.DeeperDarkerConfig;
import com.kyanite.deeperdarker.content.DDSounds;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.valueproviders.BiasedToBottomInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public class SculkSnapper
extends TamableAnimal {
    public final AnimationState idleState = new AnimationState();
    public final AnimationState attackState = new AnimationState();
    public final AnimationState sitState = new AnimationState();
    private int droppedBooks;

    public SculkSnapper(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        this.setTame(false, false);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.1, true));
        this.goalSelector.addGoal(3, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 8.0f, 2.0f));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.5));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 7.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier createAttributes() {
        return Animal.createMobAttributes().add(Attributes.MAX_HEALTH, 12.0).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.MOVEMENT_SPEED, 0.3).build();
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)DDSounds.SNAPPER_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)DDSounds.SNAPPER_HURT.get();
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (!this.level().isClientSide) {
            this.setInSittingPose(false);
            this.setOrderedToSit(false);
        }
        return super.hurt(source, amount);
    }

    public boolean doHurtTarget(Entity entity) {
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        this.playSound((SoundEvent)DDSounds.SNAPPER_BITE.get());
        return super.doHurtTarget(entity);
    }

    public void tick() {
        super.tick();
        if (this.isTame() && this.getOwner() != null && this.droppedBooks < DeeperDarkerConfig.snapperDropLimit && this.getOwner().distanceTo((Entity)this) < 5.0f && this.random.nextFloat() < 2.5E-4f) {
            Registry registry = this.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT);
            ArrayList enchantments = new ArrayList();
            registry.forEach(enchantment -> {
                if (!enchantment.effects().has(EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE) && !enchantment.effects().has(EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) {
                    enchantments.add(enchantment);
                }
            });
            Enchantment enchantment1 = (Enchantment)enchantments.remove(this.random.nextInt(enchantments.size()));
            Enchantment enchantment2 = (Enchantment)enchantments.get(this.random.nextInt(enchantments.size()));
            ItemStack book = EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(registry.wrapAsHolder((Object)enchantment1), this.random.nextInt(1, enchantment1.getMaxLevel() + 1)));
            if (this.random.nextFloat() < 0.2f) {
                book.enchant(registry.wrapAsHolder((Object)enchantment2), BiasedToBottomInt.of((int)1, (int)enchantment2.getMaxLevel()).sample(this.random));
            }
            this.level().addFreshEntity((Entity)new ItemEntity(this.level(), (double)this.blockPosition().getX(), (double)this.blockPosition().getY(), (double)this.blockPosition().getZ(), book));
            ++this.droppedBooks;
        }
        if (this.level().isClientSide()) {
            if (this.isInSittingPose() && !this.sitState.isStarted()) {
                this.idleState.stop();
                this.sitState.start(this.tickCount);
            }
            if (!this.isInSittingPose() && this.sitState.isStarted()) {
                this.sitState.stop();
            }
            if (!(this.idleState.isStarted() || this.attackState.isStarted() || this.sitState.isStarted())) {
                this.idleState.start(this.tickCount);
            }
        }
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(Items.NETHERITE_CHESTPLATE) && stack.has(DataComponents.ENCHANTMENTS);
    }

    protected void applyTamingSideEffects() {
        if (this.isTame()) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(16.0);
            this.setHealth(16.0f);
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (this.isFood(stack) && !this.isTame()) {
            this.usePlayerItem(player, hand, stack);
            if (!this.level().isClientSide()) {
                this.tame(player);
                this.setOwnerUUID(player.getUUID());
                this.setTarget(null);
                this.level().broadcastEntityEvent((Entity)this, (byte)18);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.isTame()) {
            if (stack.has(DataComponents.ENCHANTMENTS) && this.getHealth() < this.getMaxHealth()) {
                this.usePlayerItem(player, hand, stack);
                if (!this.level().isClientSide()) {
                    this.heal(this.getMaxHealth());
                    this.gameEvent((Holder)GameEvent.EAT, (Entity)this);
                }
                return InteractionResult.SUCCESS;
            }
            InteractionResult interact = super.mobInteract(player, hand);
            if (!interact.consumesAction() && this.isOwnedBy((LivingEntity)player)) {
                this.setInSittingPose(!this.isInSittingPose());
                this.setOrderedToSit(!this.isOrderedToSit());
                this.jumping = false;
                this.navigation.stop();
                this.setTarget(null);
                return InteractionResult.SUCCESS;
            }
            return interact;
        }
        return InteractionResult.PASS;
    }

    public void handleEntityEvent(byte id) {
        if (id == 4) {
            this.idleState.stop();
            this.attackState.start(this.tickCount);
        } else if (id == 18) {
            for (int i = 0; i < 7; ++i) {
                double sX = this.random.nextGaussian() * 0.02;
                double sY = this.random.nextGaussian() * 0.02;
                double sZ = this.random.nextGaussian() * 0.02;
                this.level().addParticle((ParticleOptions)ParticleTypes.HEART, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), sX, sY, sZ);
            }
        } else {
            super.handleEntityEvent(id);
        }
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        return null;
    }
}

