/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.cubeswithoutborders.client.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.platform.Monitor;
import com.mojang.blaze3d.platform.ScreenManager;
import com.mojang.blaze3d.platform.VideoMode;
import com.mojang.blaze3d.platform.Window;
import dev.kir.cubeswithoutborders.client.FullscreenManager;
import dev.kir.cubeswithoutborders.client.FullscreenMode;
import dev.kir.cubeswithoutborders.client.FullscreenType;
import dev.kir.cubeswithoutborders.client.FullscreenTypes;
import dev.kir.cubeswithoutborders.client.MonitorInfo;
import dev.kir.cubeswithoutborders.client.MonitorLookup;
import dev.kir.cubeswithoutborders.client.ResizableGameRenderer;
import dev.kir.cubeswithoutborders.client.config.CubesWithoutBordersConfig;
import dev.kir.cubeswithoutborders.client.util.SystemUtil;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={Window.class})
abstract class WindowMixin
implements FullscreenManager {
    @Shadow
    @Final
    private ScreenManager screenManager;
    @Shadow
    private Optional<VideoMode> preferredFullscreenVideoMode;
    @Shadow
    private int windowedX;
    @Shadow
    private int windowedY;
    @Shadow
    private int windowedWidth;
    @Shadow
    private int windowedHeight;
    @Shadow
    private boolean fullscreen;
    @Shadow
    private boolean actuallyFullscreen;
    private boolean borderless;
    private FullscreenType previousFullscreenType;
    private FullscreenType currentFullscreenType;

    WindowMixin() {
    }

    @Override
    public FullscreenMode getFullscreenMode() {
        return this.fullscreen ? (this.borderless ? FullscreenMode.BORDERLESS : FullscreenMode.ON) : FullscreenMode.OFF;
    }

    @Override
    public void setFullscreenMode(FullscreenMode fullscreenMode) {
        FullscreenMode currentFullscreenMode = this.getFullscreenMode();
        boolean bl = this.fullscreen = fullscreenMode != FullscreenMode.OFF;
        this.borderless = this.fullscreen ? fullscreenMode == FullscreenMode.BORDERLESS : this.borderless;
        this.actuallyFullscreen = currentFullscreenMode == fullscreenMode == this.fullscreen;
        Minecraft.getInstance().options.fullscreen().set((Object)this.fullscreen);
    }

    @WrapOperation(method={"<init>(Lcom/mojang/blaze3d/platform/WindowEventHandler;Lcom/mojang/blaze3d/platform/ScreenManager;Lcom/mojang/blaze3d/platform/DisplayData;Ljava/lang/String;Ljava/lang/String;)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/ScreenManager;getMonitor(J)Lcom/mojang/blaze3d/platform/Monitor;")})
    private Monitor fixupMonitor(ScreenManager monitorTracker, long pointer, Operation<Monitor> getMonitor) {
        this.actuallyFullscreen = false;
        this.fullscreen = false;
        CubesWithoutBordersConfig config = CubesWithoutBordersConfig.getInstance();
        Monitor monitor = (Monitor)getMonitor.call(new Object[]{monitorTracker, pointer});
        Optional<Monitor> preferredMonitor = MonitorLookup.findMonitor(monitorTracker, config.getPreferredMonitor());
        return SystemUtil.isWindows() ? preferredMonitor.orElse(monitor) : monitor;
    }

    @WrapOperation(method={"<init>(Lcom/mojang/blaze3d/platform/WindowEventHandler;Lcom/mojang/blaze3d/platform/ScreenManager;Lcom/mojang/blaze3d/platform/DisplayData;Ljava/lang/String;Ljava/lang/String;)V"}, at={@At(value="INVOKE", target="Lorg/lwjgl/glfw/GLFW;glfwMakeContextCurrent(J)V")})
    private void init(long handle, Operation<Void> glfwMakeContextCurrent) {
        Window window = (Window)this;
        CubesWithoutBordersConfig config = CubesWithoutBordersConfig.getInstance();
        this.actuallyFullscreen = config.getFullscreenMode() != FullscreenMode.OFF;
        this.fullscreen = this.actuallyFullscreen;
        this.borderless = config.getPreferredFullscreenMode() == FullscreenMode.BORDERLESS;
        this.borderless = this.borderless || config.getFullscreenMode() == FullscreenMode.BORDERLESS;
        this.currentFullscreenType = null;
        this.previousFullscreenType = null;
        Monitor currentMonitor = this.screenManager.findBestMonitor(window);
        Monitor preferredMonitor = MonitorLookup.findMonitor(this.screenManager, config.getPreferredMonitor()).orElse(currentMonitor);
        if (preferredMonitor != currentMonitor && SystemUtil.isWindows()) {
            VideoMode videoMode = preferredMonitor.getCurrentMode();
            this.windowedX = window.x = preferredMonitor.getX() + (videoMode.getWidth() - window.width) / 2;
            this.windowedY = window.y = preferredMonitor.getY() + (videoMode.getHeight() - window.height) / 2;
            GLFW.glfwSetWindowMonitor((long)handle, (long)0L, (int)window.x, (int)window.y, (int)window.width, (int)window.height, (int)-1);
        }
        glfwMakeContextCurrent.call(new Object[]{handle});
    }

    @Inject(method={"setMode()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void enableFullscreen(CallbackInfo ci) {
        boolean wasInWindowedMode;
        Window window = (Window)this;
        CubesWithoutBordersConfig config = CubesWithoutBordersConfig.getInstance();
        this.previousFullscreenType = this.currentFullscreenType;
        if (!this.fullscreen) {
            this.currentFullscreenType = null;
            return;
        }
        FullscreenType requestedFullscreenType = this.borderless ? config.getBorderlessFullscreenType() : config.getFullscreenType();
        FullscreenType defaultFullscreenType = this.borderless ? FullscreenTypes.borderless() : FullscreenTypes.exclusive();
        this.currentFullscreenType = FullscreenTypes.validate(requestedFullscreenType, defaultFullscreenType);
        Monitor monitor = this.screenManager.findBestMonitor(window);
        if (monitor == null) {
            this.currentFullscreenType = null;
            return;
        }
        if (this.currentFullscreenType == FullscreenTypes.DEFAULT) {
            return;
        }
        boolean bl = wasInWindowedMode = this.previousFullscreenType == null;
        if (wasInWindowedMode) {
            this.windowedX = window.x;
            this.windowedY = window.y;
            this.windowedWidth = window.width;
            this.windowedHeight = window.height;
        } else {
            this.previousFullscreenType.disable(window);
            ResizableGameRenderer.getInstance().disable();
        }
        VideoMode videoMode = monitor.getPreferredVidMode(this.preferredFullscreenVideoMode);
        this.currentFullscreenType.enable(window, monitor, videoMode);
        int targetWidth = videoMode.getWidth();
        int targetHeight = videoMode.getHeight();
        int deltaWidth = Math.abs(window.width - targetWidth);
        int deltaHeight = Math.abs(window.height - targetHeight);
        if (deltaWidth > 1 || deltaHeight > 1) {
            float targetScale = Math.min((float)targetWidth / (float)window.width, (float)targetHeight / (float)window.height);
            int scaledWidth = Math.round((float)window.width * targetScale);
            int scaledHeight = Math.round((float)window.height * targetScale);
            ResizableGameRenderer.getInstance().resize(scaledWidth, scaledHeight);
        }
        ci.cancel();
    }

    @Inject(method={"setMode()V"}, at={@At(value="INVOKE", target="Lorg/lwjgl/glfw/GLFW;glfwSetWindowMonitor(JJIIIII)V", ordinal=0), @At(value="FIELD", target="Lcom/mojang/blaze3d/platform/Window;windowedX:I", ordinal=1)})
    private void disableFullscreen(CallbackInfo ci) {
        if (this.previousFullscreenType == null) {
            return;
        }
        this.previousFullscreenType.disable((Window)this);
        ResizableGameRenderer.getInstance().disable();
    }

    @WrapOperation(method={"setMode()V"}, at={@At(value="INVOKE", target="Lorg/lwjgl/glfw/GLFW;glfwGetWindowMonitor(J)J", ordinal=0)})
    private long getWindowMonitorIfWindowed(long handle, Operation<Long> getWindowMonitor) {
        if (this.previousFullscreenType != null) {
            return -1L;
        }
        return (Long)getWindowMonitor.call(new Object[]{handle});
    }

    @Inject(method={"close()V"}, at={@At(value="HEAD")})
    private void save(CallbackInfo ci) {
        Window window = (Window)this;
        Monitor monitor = this.screenManager.findBestMonitor(window);
        CubesWithoutBordersConfig config = CubesWithoutBordersConfig.getInstance();
        config.setFullscreenMode(this.getFullscreenMode());
        config.setPreferredFullscreenMode(this.borderless ? FullscreenMode.BORDERLESS : FullscreenMode.ON);
        config.setPreferredMonitor(monitor == null ? MonitorInfo.primary() : MonitorInfo.of(monitor));
        config.save();
        Options options = Minecraft.getInstance().options;
        options.fullscreen().set((Object)this.fullscreen);
        options.save();
    }
}

