/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.cubeswithoutborders.client.compat.cloth;

import dev.kir.cubeswithoutborders.client.FullscreenType;
import dev.kir.cubeswithoutborders.client.FullscreenTypes;
import dev.kir.cubeswithoutborders.client.config.CubesWithoutBordersConfig;
import java.util.List;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class ClothConfigScreen {
    public static Screen create(CubesWithoutBordersConfig config, String modId, Screen parent) {
        MutableComponent title = Component.translatable((String)("modmenu.nameTranslation." + modId));
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((Component)title);
        Minecraft client = Minecraft.getInstance();
        ConfigCategory category = builder.getOrCreateCategory((Component)title);
        ConfigEntryBuilder entries = builder.entryBuilder();
        MutableComponent pauseOnLostFocusText = Component.translatable((String)"options.pauseOnLostFocus");
        boolean currentPauseOnLostFocus = client.options.pauseOnLostFocus;
        category.addEntry((AbstractConfigListEntry)entries.startBooleanToggle((Component)pauseOnLostFocusText, currentPauseOnLostFocus).setDefaultValue(true).setSaveConsumer(x -> {
            client.options.pauseOnLostFocus = x;
        }).build());
        MutableComponent fullscreenTypeText = Component.translatable((String)"options.fullscreenType");
        FullscreenType defaultFullscreenType = FullscreenTypes.exclusive();
        FullscreenType currentFullscreenType = FullscreenTypes.validate(config.getFullscreenType(), defaultFullscreenType);
        List fullscreenTypeSelections = FullscreenTypes.stream().map(FullscreenType::id).collect(Collectors.toList());
        category.addEntry((AbstractConfigListEntry)entries.startStringDropdownMenu((Component)fullscreenTypeText, currentFullscreenType.id()).requireRestart().setSuggestionMode(false).setDefaultValue((Object)defaultFullscreenType.id()).setSelections(fullscreenTypeSelections).setSaveConsumer(x -> FullscreenTypes.get(x).ifPresent(config::setFullscreenType)).build());
        MutableComponent borderlessFullscreenTypeText = Component.translatable((String)"options.borderlessFullscreenType");
        FullscreenType defaultBorderlessFullscreenType = FullscreenTypes.borderless();
        FullscreenType currentBorderlessFullscreenType = FullscreenTypes.validate(config.getBorderlessFullscreenType(), defaultBorderlessFullscreenType);
        category.addEntry((AbstractConfigListEntry)entries.startStringDropdownMenu((Component)borderlessFullscreenTypeText, currentBorderlessFullscreenType.id()).requireRestart().setSuggestionMode(false).setDefaultValue((Object)defaultBorderlessFullscreenType.id()).setSelections(fullscreenTypeSelections).setSaveConsumer(x -> FullscreenTypes.get(x).ifPresent(config::setBorderlessFullscreenType)).build());
        return builder.build();
    }

    private ClothConfigScreen() {
    }
}

