/*
 * Decompiled with CFR 0.152.
 */
package com.ludwici.crumbslib.api;

import com.ludwici.crumbslib.api.ModHelper;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BannerPattern;

public class TagHelper {
    public static TagKey<Item> item(String name) {
        return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)ModHelper.getModId(), (String)name));
    }

    public static TagKey<Block> block(String name) {
        return BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)ModHelper.getModId(), (String)name));
    }

    public static <T> TagKey<T> create(ResourceKey<Registry<T>> reg, String name) {
        return TagKey.create(reg, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)ModHelper.getModId(), (String)name));
    }

    public static <T> TagKey<T> createConvention(ResourceKey<Registry<T>> reg, String name) {
        return TagKey.create(reg, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
    }

    public static TagKey<Biome> biome(String name) {
        return TagHelper.create(Registries.BIOME, name);
    }

    public static TagKey<EntityType<?>> entityType(String name) {
        return TagHelper.create(Registries.ENTITY_TYPE, name);
    }

    public static TagKey<BannerPattern> bannerPattern(String name) {
        return TagHelper.create(Registries.BANNER_PATTERN, name);
    }
}

