/*
 * Decompiled with CFR 0.152.
 */
package com.ludwici.crumbslib.api;

import com.ludwici.crumbslib.api.CrumbSupplier;
import com.ludwici.crumbslib.api.ModHelper;
import java.util.function.Supplier;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ItemHelper {
    public static DeferredRegister.Items ITEMS;

    public static void initBus() {
        ITEMS = DeferredRegister.createItems((String)ModHelper.getModId());
        ITEMS.register(ModHelper.getEventBus());
    }

    public static <T extends Item> CrumbSupplier<T> register(String name, Supplier<T> supplier) {
        DeferredItem ret = ITEMS.register(name, supplier);
        return new CrumbSupplier(ret);
    }

    public static <T extends Mob> CrumbSupplier<Item> registerSpawnEgg(CrumbSupplier<EntityType<T>> mob, int backgroundColor, int highlightColor) {
        return ItemHelper.register(mob.getId().getPath() + "_spawn_egg", () -> new SpawnEggItem((EntityType)mob.get(), backgroundColor, highlightColor, new Item.Properties()));
    }

    public static CrumbSupplier<BannerPatternItem> registerBanner(String name, TagKey<BannerPattern> tag) {
        return ItemHelper.register("banner_pattern_" + name, () -> new BannerPatternItem(tag, new Item.Properties().stacksTo(1)));
    }
}

