#
#    Teleporting from creative to survival
#

# 1. Set gamemode survival and clear inventory
gamemode survival
function creativerse:clear_inventory

# 2. Forceload chunk and leave marker for when we want to return
forceload add ~ ~
summon minecraft:marker ~ ~ ~ {Tags:["creativerse_creative"]}
scoreboard players operation @n[type=minecraft:marker, nbt={Tags:["creativerse_creative"]}] creativerse_id = @s creativerse_id

# 3. Find corresponding marker in other dimension and teleport player to marker
execute in minecraft:overworld run tp @p[scores={creativerse_exit=1}] ~ ~ ~
execute as @e[type=marker, nbt={Tags:["creativerse_survival"]}] if score @s creativerse_id = @p[scores={creativerse_exit=1}] creativerse_id run scoreboard players set @s creativerse_target 1 
execute in minecraft:overworld run tp @p[scores={creativerse_exit=1}] @e[limit=1, scores={creativerse_target=1}]

# 4. Recover items from storage
execute as @p[scores={creativerse_exit=1}] at @s run function creativerse:recover_inventory

# 5. Kill marker and stop forceloading (TODO: multiple markers by different players in the same chunk? Does it break? needs testing)
execute at @p[scores={creativerse_exit=1}] run kill @n[type=marker, nbt={Tags:["creativerse_survival"]}]
execute at @p[scores={creativerse_exit=1}] run forceload remove ~ ~
execute at @e[type=marker, nbt={Tags:["creativerse_survival"]}] run forceload add ~ ~

# 6. Revoke creativerse status
scoreboard players set @p[scores={creativerse_exit=1}] creativerse_status 0

# 7.
tellraw @s ["",{"text":"You have left the "},{"text":"creativerse","color":"yellow"},{"text":".\nType or click "},{"text":"/trigger creativerse_enter","color":"green","clickEvent":{"action":"run_command","value":"/trigger creativerse_enter"}},{"text":" to return!"}]