#
#    Teleporting from survival to creative
#

# 1. Forceload chunk and leave marker for when we want to return
forceload add ~ ~
summon minecraft:marker ~ ~ ~ {Tags:["creativerse_survival"]}
scoreboard players operation @e[type=minecraft:marker, sort=nearest, limit=1] creativerse_id = @s creativerse_id

# 2. Prepare Inventory
execute as @s run function creativerse:store_inventory
execute as @s run function creativerse:clear_inventory

# 3. Teleport to origin. If there is a marker also teleport to the marker
execute in creativerse:creativerse run tp @s 0 320 0
execute as @e[type=marker, nbt={Tags:["creativerse_creative"]}] if score @s creativerse_id = @p[scores={creativerse_enter=1}] creativerse_id run scoreboard players set @s creativerse_target 1 
execute in creativerse:creativerse run tp @p[scores={creativerse_enter=1}] @e[limit=1, scores={creativerse_target=1}]

# 4. Kill marker and stop forceloading
execute at @p[scores={creativerse_enter=1}] run kill @e[type=marker, sort=nearest, limit=1, nbt={Tags:["creativerse_creative"]}]
execute at @p[scores={creativerse_enter=1}] run forceload remove ~ ~
execute at @e[type=marker, nbt={Tags:["creativerse_creative"]}] run forceload add ~ ~

# 5. Set gamemode creative and creativerse status
execute as @p[scores={creativerse_enter=1}] run gamemode creative
scoreboard players set @p[scores={creativerse_enter=1}] creativerse_status 1

# 6. Display info
execute as @p[scores={creativerse_enter=1}] run tellraw @s ["",{"text":"Welcome to the "},{"text":"creativerse","color":"yellow"},{"text":"!\nType or click "},{"text":"/trigger creativerse_exit","color":"green","clickEvent":{"action":"run_command","value":"/trigger creativerse_exit"}},{"text":" to return to the survival world."}]