/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.liquid_blaze_burner;

import com.mrh0.createaddition.blocks.liquid_blaze_burner.LiquidBlazeBurnerBlock;
import com.mrh0.createaddition.index.CABlockEntities;
import com.mrh0.createaddition.index.CALang;
import com.mrh0.createaddition.index.CARecipes;
import com.mrh0.createaddition.network.IObserveBlockEntity;
import com.mrh0.createaddition.network.ObservePacketPayload;
import com.mrh0.createaddition.network.TimeRemainingPacketPayload;
import com.mrh0.createaddition.recipe.FluidRecipeWrapper;
import com.mrh0.createaddition.recipe.liquid_burning.LiquidBurningRecipe;
import com.mrh0.createaddition.util.Util;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllTags;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.fluids.tank.FluidTankBlock;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.Nullable;

public class LiquidBlazeBurnerBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
IObserveBlockEntity {
    public static final int MAX_HEAT_CAPACITY = 10000;
    protected FuelType activeFuel;
    protected int remainingBurnTime = 0;
    protected LerpedFloat headAnimation;
    protected LerpedFloat headAngle;
    protected boolean isCreative = false;
    protected boolean goggles = false;
    protected boolean hat;
    public final boolean stockKeeper = false;
    BlazeBurnerBlock.HeatLevel heatLevel;
    protected FluidTank tankInventory;
    private Optional<RecipeHolder<LiquidBurningRecipe>> recipeCache = Optional.empty();
    private Fluid lastFluid = null;
    public boolean first = true;

    public LiquidBlazeBurnerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.activeFuel = FuelType.NONE;
        this.headAnimation = LerpedFloat.linear();
        this.headAngle = LerpedFloat.angular();
        this.headAngle.startWithValue((double)((AngleHelper.horizontalAngle((Direction)state.getOptionalValue((Property)LiquidBlazeBurnerBlock.FACING).orElse(Direction.SOUTH)) + 180.0f) % 360.0f));
        this.tankInventory = this.createInventory();
        this.heatLevel = this.getHeatLevelFromBlock();
    }

    public void addBehaviours(List<BlockEntityBehaviour> list) {
    }

    public BlazeBurnerBlock.HeatLevel getHeatLevelForRender() {
        return this.getHeatLevelFromBlock();
    }

    public static void registerCapability(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)CABlockEntities.LIQUID_BLAZE_BURNER.get(), (be, direction) -> be.tankInventory);
    }

    protected SmartFluidTank createInventory() {
        return new SmartFluidTank(4000, this::onFluidStackChanged);
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        if (!this.hasLevel()) {
            return;
        }
        this.update(newFluidStack);
    }

    private void update(FluidStack stack) {
        if (this.level == null) {
            return;
        }
        if (this.level.isClientSide()) {
            return;
        }
        if (stack.getFluid() != this.lastFluid) {
            this.recipeCache = this.find(stack, this.level);
        }
        this.lastFluid = stack.getFluid();
    }

    public Optional<RecipeHolder<LiquidBurningRecipe>> find(@Nullable FluidStack stack, @Nullable Level level) {
        if (stack == null || level == null) {
            return Optional.empty();
        }
        if (CARecipes.LIQUID_BURNING_TYPE.get() == null) {
            return Optional.empty();
        }
        return level.getRecipeManager().getRecipeFor(CARecipes.LIQUID_BURNING_TYPE.get(), (RecipeInput)new FluidRecipeWrapper(stack), level);
    }

    public void burningTick() {
        if (this.level == null) {
            return;
        }
        if (this.level.isClientSide()) {
            return;
        }
        if (this.first) {
            this.update(this.tankInventory.getFluid());
        }
        this.first = false;
        if (this.remainingBurnTime < 1 && this.recipeCache.isEmpty()) {
            return;
        }
        if (this.tankInventory.getFluidAmount() < 100) {
            return;
        }
        if (this.remainingBurnTime > 10000) {
            return;
        }
        if (this.recipeCache.isEmpty()) {
            return;
        }
        try {
            LiquidBurningRecipe recipe = (LiquidBurningRecipe)this.recipeCache.get().value();
            int burnTime = recipe.getBurnTime() / 10;
            FuelType fuelType = recipe.isSuperheated() ? FuelType.SPECIAL : FuelType.NORMAL;
            this.remainingBurnTime = this.activeFuel == fuelType ? this.remainingBurnTime + burnTime : burnTime;
            this.activeFuel = fuelType;
        }
        catch (Exception e) {
            return;
        }
        this.tankInventory.drain(100, IFluidHandler.FluidAction.EXECUTE);
        BlazeBurnerBlock.HeatLevel prev = this.heatLevel;
        this.playSound();
        this.updateBlockState();
        if (prev != this.heatLevel) {
            this.level.playSound(null, this.worldPosition, SoundEvents.BLAZE_AMBIENT, SoundSource.BLOCKS, 0.125f + this.level.random.nextFloat() * 0.125f, 1.15f - this.level.random.nextFloat() * 0.25f);
            this.spawnParticleBurst(this.activeFuel == FuelType.SPECIAL);
        }
    }

    public FuelType getActiveFuel() {
        return this.activeFuel;
    }

    public int getRemainingBurnTime() {
        return this.remainingBurnTime;
    }

    public boolean isCreative() {
        return this.isCreative;
    }

    public void tick() {
        super.tick();
        if (this.level == null) {
            return;
        }
        if (this.level.isClientSide) {
            this.tickAnimation();
            if (!this.isVirtual()) {
                this.spawnParticles(this.getHeatLevelForRender(), 1.0);
            }
            return;
        }
        this.burningTick();
        if (this.isCreative) {
            return;
        }
        if (this.remainingBurnTime > 0) {
            --this.remainingBurnTime;
        }
        if (this.remainingBurnTime > 0) {
            return;
        }
        if (this.activeFuel == FuelType.SPECIAL) {
            this.activeFuel = FuelType.NORMAL;
            this.remainingBurnTime = 5000;
        } else {
            this.activeFuel = FuelType.NONE;
        }
        this.updateBlockState();
    }

    public void lazyTick() {
        super.lazyTick();
    }

    @OnlyIn(value=Dist.CLIENT)
    void tickAnimation() {
        boolean active;
        BlazeBurnerBlock.HeatLevel serverHeatLevel = this.getHeatLevelForRender();
        boolean bl = active = serverHeatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING) && this.isValidBlockAbove();
        if (!active) {
            float target = 0.0f;
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null && !player.isInvisible()) {
                double z;
                double x;
                if (this.isVirtual()) {
                    x = -4.0;
                    z = -10.0;
                } else {
                    x = player.getX();
                    z = player.getZ();
                }
                double dx = x - ((double)this.getBlockPos().getX() + 0.5);
                double dz = z - ((double)this.getBlockPos().getZ() + 0.5);
                target = AngleHelper.deg((double)(-Mth.atan2((double)dz, (double)dx))) - 90.0f;
            }
            target = this.headAngle.getValue() + AngleHelper.getShortestAngleDiff((double)this.headAngle.getValue(), (double)target);
            this.headAngle.chase((double)target, 0.25, LerpedFloat.Chaser.exp((double)5.0));
            this.headAngle.tickChaser();
        } else {
            this.headAngle.chase((double)((AngleHelper.horizontalAngle((Direction)this.getBlockState().getOptionalValue((Property)LiquidBlazeBurnerBlock.FACING).orElse(Direction.SOUTH)) + 180.0f) % 360.0f), 0.125, LerpedFloat.Chaser.EXP);
            this.headAngle.tickChaser();
        }
        this.headAnimation.chase(active ? 1.0 : 0.0, 0.25, LerpedFloat.Chaser.exp((double)0.25));
        this.headAnimation.tickChaser();
    }

    public void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        if (!this.isCreative) {
            tag.putInt("fuelLevel", this.activeFuel.ordinal());
            tag.putInt("burnTimeRemaining", this.remainingBurnTime);
        } else {
            tag.putBoolean("isCreative", true);
        }
        if (this.goggles) {
            tag.putBoolean("Goggles", true);
        }
        if (this.hat) {
            tag.putBoolean("TrainHat", true);
        }
        tag.put("TankContent", (Tag)this.tankInventory.writeToNBT(registries, new CompoundTag()));
        super.write(tag, registries, clientPacket);
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        this.activeFuel = FuelType.values()[tag.getInt("fuelLevel")];
        this.remainingBurnTime = tag.getInt("burnTimeRemaining");
        this.isCreative = tag.getBoolean("isCreative");
        this.goggles = tag.contains("Goggles");
        this.hat = tag.contains("TrainHat");
        this.tankInventory.readFromNBT(registries, tag.getCompound("TankContent"));
        super.read(tag, registries, clientPacket);
    }

    public BlazeBurnerBlock.HeatLevel getHeatLevelFromBlock() {
        return LiquidBlazeBurnerBlock.getHeatLevelOf(this.getBlockState());
    }

    public void updateBlockState() {
        this.setBlockHeat(this.getHeatLevelFromFuelType(this.activeFuel));
    }

    protected void setBlockHeat(BlazeBurnerBlock.HeatLevel heat) {
        if (this.level == null) {
            return;
        }
        if (this.heatLevel == heat) {
            return;
        }
        this.heatLevel = heat;
        this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)BlazeBurnerBlock.HEAT_LEVEL, (Comparable)heat));
        this.notifyUpdate();
    }

    private boolean tryUpdateLiquid(ItemStack itemStack, boolean simulate) {
        if (this.level == null) {
            return false;
        }
        IFluidHandlerItem itemHandler = (IFluidHandlerItem)itemStack.getCapability(Capabilities.FluidHandler.ITEM);
        if (itemHandler == null) {
            return false;
        }
        if (itemHandler.getFluidInTank(0).isEmpty()) {
            return false;
        }
        FluidStack stack = itemHandler.getFluidInTank(0);
        Optional<RecipeHolder<LiquidBurningRecipe>> recipe = this.find(stack, this.level);
        if (recipe.isEmpty()) {
            return false;
        }
        IFluidHandler beHandler = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, this.getBlockPos(), null);
        if (beHandler == null) {
            return false;
        }
        if (beHandler.getTankCapacity(0) - beHandler.getFluidInTank(0).getAmount() < 1000) {
            return false;
        }
        if (!simulate) {
            beHandler.fill(new FluidStack(itemHandler.getFluidInTank(0).getFluid(), 1000), IFluidHandler.FluidAction.EXECUTE);
        }
        if (!simulate) {
            this.level.playSound(null, this.getBlockPos(), SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 0.125f + this.level.random.nextFloat() * 0.125f, 0.75f - this.level.random.nextFloat() * 0.25f);
        }
        return true;
    }

    protected boolean tryUpdateFuel(ItemStack itemStack, boolean forceOverflow, boolean simulate) {
        int newBurnTime;
        if (this.isCreative) {
            return false;
        }
        FuelType newFuel = FuelType.NONE;
        if (this.tryUpdateLiquid(itemStack, simulate)) {
            return true;
        }
        if (AllTags.AllItemTags.BLAZE_BURNER_FUEL_SPECIAL.matches(itemStack)) {
            newBurnTime = 1000;
            newFuel = FuelType.SPECIAL;
        } else {
            newBurnTime = itemStack.getBurnTime(null);
            if (newBurnTime > 0) {
                newFuel = FuelType.NORMAL;
            } else if (AllTags.AllItemTags.BLAZE_BURNER_FUEL_REGULAR.matches(itemStack)) {
                newBurnTime = 1600;
                newFuel = FuelType.NORMAL;
            }
        }
        if (newFuel == FuelType.NONE) {
            return false;
        }
        if (newFuel.ordinal() < this.activeFuel.ordinal()) {
            return false;
        }
        if (this.activeFuel == FuelType.SPECIAL && this.remainingBurnTime > 20) {
            return false;
        }
        if (newFuel == this.activeFuel) {
            if (this.remainingBurnTime + newBurnTime > 10000 && !forceOverflow) {
                return false;
            }
            newBurnTime = Mth.clamp((int)(this.remainingBurnTime + newBurnTime), (int)0, (int)10000);
        }
        if (simulate) {
            return true;
        }
        this.activeFuel = newFuel;
        this.remainingBurnTime = newBurnTime;
        if (this.level == null) {
            return false;
        }
        if (this.level.isClientSide) {
            this.spawnParticleBurst(this.activeFuel == FuelType.SPECIAL);
            return true;
        }
        BlazeBurnerBlock.HeatLevel prev = this.heatLevel;
        this.playSound();
        this.updateBlockState();
        if (prev != this.heatLevel) {
            this.level.playSound(null, this.worldPosition, SoundEvents.BLAZE_AMBIENT, SoundSource.BLOCKS, 0.125f + this.level.random.nextFloat() * 0.125f, 1.15f - this.level.random.nextFloat() * 0.25f);
        }
        return true;
    }

    protected void applyCreativeFuel() {
        this.activeFuel = FuelType.NONE;
        this.remainingBurnTime = 0;
        this.isCreative = true;
        BlazeBurnerBlock.HeatLevel next = this.heatLevel.nextActiveLevel();
        if (this.level.isClientSide) {
            this.spawnParticleBurst(next.isAtLeast(BlazeBurnerBlock.HeatLevel.SEETHING));
            return;
        }
        this.playSound();
        if (next == BlazeBurnerBlock.HeatLevel.FADING) {
            next = next.nextActiveLevel();
        }
        this.setBlockHeat(next);
    }

    public boolean isCreativeFuel(ItemStack stack) {
        return AllItems.CREATIVE_BLAZE_CAKE.isIn(stack);
    }

    public boolean isValidBlockAbove() {
        BlockState blockState = this.level.getBlockState(this.worldPosition.above());
        return AllBlocks.BASIN.has(blockState) || blockState.getBlock() instanceof FluidTankBlock;
    }

    protected void playSound() {
        this.level.playSound(null, this.worldPosition, SoundEvents.BLAZE_SHOOT, SoundSource.BLOCKS, 0.125f + this.level.random.nextFloat() * 0.125f, 0.75f - this.level.random.nextFloat() * 0.25f);
    }

    protected BlazeBurnerBlock.HeatLevel getHeatLevelFromFuelType(FuelType fuel) {
        BlazeBurnerBlock.HeatLevel level = BlazeBurnerBlock.HeatLevel.SMOULDERING;
        switch (this.activeFuel.ordinal()) {
            case 2: {
                level = BlazeBurnerBlock.HeatLevel.SEETHING;
                break;
            }
            case 1: {
                boolean lowPercent = (double)this.remainingBurnTime / 10000.0 < 0.0125;
                level = lowPercent ? BlazeBurnerBlock.HeatLevel.FADING : BlazeBurnerBlock.HeatLevel.KINDLED;
                break;
            }
        }
        return level;
    }

    protected void spawnParticles(BlazeBurnerBlock.HeatLevel heatLevel, double burstMult) {
        if (this.level == null) {
            return;
        }
        if (heatLevel == BlazeBurnerBlock.HeatLevel.NONE) {
            return;
        }
        RandomSource r = this.level.getRandom();
        Vec3 c = VecHelper.getCenterOf((Vec3i)this.worldPosition);
        Vec3 v = c.add(VecHelper.offsetRandomly((Vec3)Vec3.ZERO, (RandomSource)r, (float)0.125f).multiply(1.0, 0.0, 1.0));
        if (r.nextInt(3) == 0) {
            this.level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, v.x, v.y, v.z, 0.0, 0.0, 0.0);
        }
        if (r.nextInt(2) != 0) {
            return;
        }
        boolean empty = this.level.getBlockState(this.worldPosition.above()).getCollisionShape((BlockGetter)this.level, this.worldPosition.above()).isEmpty();
        double yMotion = empty ? 0.0625 : r.nextDouble() * (double)0.0125f;
        Vec3 v2 = c.add(VecHelper.offsetRandomly((Vec3)Vec3.ZERO, (RandomSource)r, (float)0.5f).multiply(1.0, 0.25, 1.0).normalize().scale((empty ? 0.25 : 0.5) + r.nextDouble() * 0.125)).add(0.0, 0.5, 0.0);
        if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.SEETHING)) {
            this.level.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, v2.x, v2.y, v2.z, 0.0, yMotion, 0.0);
        } else if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
            this.level.addParticle((ParticleOptions)ParticleTypes.FLAME, v2.x, v2.y, v2.z, 0.0, yMotion, 0.0);
        }
    }

    public void spawnParticleBurst(boolean soulFlame) {
        Vec3 c = VecHelper.getCenterOf((Vec3i)this.worldPosition);
        RandomSource r = this.level.random;
        for (int i = 0; i < 20; ++i) {
            Vec3 offset = VecHelper.offsetRandomly((Vec3)Vec3.ZERO, (RandomSource)r, (float)0.5f).multiply(1.0, 0.25, 1.0).normalize();
            Vec3 v = c.add(offset.scale(0.5 + r.nextDouble() * 0.125)).add(0.0, 0.125, 0.0);
            Vec3 m = offset.scale(0.03125);
            this.level.addParticle((ParticleOptions)(soulFlame ? ParticleTypes.SOUL_FIRE_FLAME : ParticleTypes.FLAME), v.x, v.y, v.z, m.x, m.y, m.z);
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (this.level == null) {
            return false;
        }
        ObservePacketPayload.send(this.worldPosition, 0);
        this.containedFluidTooltip(tooltip, isPlayerSneaking, (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, this.getBlockPos(), null));
        if (TimeRemainingPacketPayload.clientTimeRemaining > 20) {
            CALang.builder().add(Component.literal((String)" ").append((Component)Component.translatable((String)"createaddition.tooltip.liquid_burning.time_remaining").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)(" " + Util.formatTime(TimeRemainingPacketPayload.clientTimeRemaining))).withStyle(ChatFormatting.AQUA))).forGoggles(tooltip);
        }
        return true;
    }

    @Override
    public void onObserved(ServerPlayer player, ObservePacketPayload pack) {
        TimeRemainingPacketPayload.send(this.remainingBurnTime, player);
    }

    public static enum FuelType {
        NONE,
        NORMAL,
        SPECIAL;

    }
}

