/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.blocks;

import com.pedrorok.hypertube.blocks.TubeBlock;
import com.pedrorok.hypertube.blocks.blockentities.HyperAcceleratorBlockEntity;
import com.pedrorok.hypertube.core.connection.interfaces.ITubeActionPoint;
import com.pedrorok.hypertube.core.sound.TubeSoundManager;
import com.pedrorok.hypertube.core.travel.TravelPathMover;
import com.pedrorok.hypertube.network.packets.SpeedChangePacket;
import com.pedrorok.hypertube.registry.ModBlockEntities;
import com.pedrorok.hypertube.registry.ModBlocks;
import com.pedrorok.hypertube.utils.MessageUtils;
import com.pedrorok.hypertube.utils.TubeUtils;
import com.pedrorok.hypertube.utils.VoxelUtils;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HyperAcceleratorBlock
extends TubeBlock
implements EntityBlock,
ICogWheel,
ITubeActionPoint {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");
    public static final BooleanProperty ACCELERATE = BooleanProperty.create((String)"accelerate");

    public HyperAcceleratorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).setValue((Property)ACCELERATE, (Comparable)Boolean.valueOf(true)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, OPEN, WATERLOGGED, ACTIVE, ACCELERATE});
        super.createBlockStateDefinition(builder);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Player player = context.getPlayer();
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        if (player == null) {
            return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace().getOpposite())).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.is((Fluid)Fluids.WATER)));
        }
        Direction direction = player.getDirection();
        if (player.getXRot() < -45.0f) {
            direction = Direction.UP;
        } else if (player.getXRot() > 45.0f) {
            direction = Direction.DOWN;
        }
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.is((Fluid)Fluids.WATER)));
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)mirror.mirror((Direction)state.getValue((Property)FACING)));
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.getValue((Property)FACING)).getAxis();
    }

    @Override
    public Item getItem() {
        return ModBlocks.HYPER_ACCELERATOR.asItem();
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return ((BlockEntityType)ModBlockEntities.HYPER_ACCELERATOR.get()).create(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return (level1, pos, state1, be) -> ((HyperAcceleratorBlockEntity)be).tick();
    }

    @Override
    public List<Direction> getConnectedFaces(BlockState state) {
        return new ArrayList<Direction>(List.of(((Direction)state.getValue((Property)FACING)).getOpposite(), (Direction)state.getValue((Property)FACING)));
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        HyperAcceleratorBlockEntity entrance;
        BlockEntity blockEntity = context.getLevel().getBlockEntity(context.getClickedPos());
        if (blockEntity instanceof HyperAcceleratorBlockEntity && (entrance = (HyperAcceleratorBlockEntity)blockEntity).wrenchClicked(context.getClickedFace())) {
            IWrenchable.playRotateSound((Level)context.getLevel(), (BlockPos)context.getClickedPos());
            return InteractionResult.SUCCESS;
        }
        Player player = context.getPlayer();
        BlockState blockState = (BlockState)state.setValue((Property)ACCELERATE, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)ACCELERATE) == false));
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        level.setBlock(pos, blockState, 3);
        if (((Boolean)blockState.getValue((Property)ACCELERATE)).booleanValue()) {
            MessageUtils.sendActionMessage(player, (Component)Component.translatable((String)"block.hypertube.hyper_accelerator.accelerate_mode").withColor(0xFFFF00), true);
        } else {
            MessageUtils.sendActionMessage(player, (Component)Component.translatable((String)"block.hypertube.hyper_accelerator.brake_mode").withColor(0xFF8800), true);
        }
        IWrenchable.playRotateSound((Level)context.getLevel(), (BlockPos)context.getClickedPos());
        return InteractionResult.SUCCESS;
    }

    @Override
    public void handleTravelPath(LivingEntity entity, TravelPathMover mover, BlockPos pos) {
        Level level = entity.level();
        HyperAcceleratorBlockEntity tube = (HyperAcceleratorBlockEntity)level.getBlockEntity(pos);
        if (tube == null || mover == null) {
            return;
        }
        float speed = TubeUtils.calculateTravelSpeed(Math.abs(tube.getSpeed())) / 2.0f;
        float newSpeed = mover.getTravelSpeed() + speed * (float)((Boolean)tube.getBlockState().getValue((Property)ACCELERATE) != false ? 1 : -1);
        newSpeed = Math.max(0.4333f, newSpeed);
        mover.setTravelSpeed(newSpeed);
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)new SpeedChangePacket(entity.getId(), newSpeed), (CustomPacketPayload[])new CustomPacketPayload[0]);
        TubeSoundManager.playTubeSuctionSound(entity, entity.position());
    }

    @Override
    public VoxelShape getShape(BlockState state, @Nullable CollisionContext ctx) {
        EntityCollisionContext ecc;
        if (ctx instanceof EntityCollisionContext && (ecc = (EntityCollisionContext)ctx).getEntity() != null && ecc.getEntity().getPersistentData().getBoolean("hypertube_travel")) {
            return VoxelUtils.empty();
        }
        return Shapes.block();
    }

    public boolean isSmallCog() {
        return true;
    }
}

