/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.kinetics.grindstone;

import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.GrindstoneEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import plus.dragons.createenchantmentindustry.common.kinetics.grindstone.GrindingRecipe;
import plus.dragons.createenchantmentindustry.common.registry.CEIRecipes;

public class GrindstoneHelper {
    public static boolean canItemBeGrinded(Level level, ItemStack top, ItemStack bottom) {
        GrindstoneEvent.OnPlaceItem event = (GrindstoneEvent.OnPlaceItem)NeoForge.EVENT_BUS.post((Event)new GrindstoneEvent.OnPlaceItem(top, bottom, -1));
        if (event.isCanceled()) {
            return false;
        }
        if (!event.getOutput().isEmpty()) {
            return true;
        }
        return !GrindstoneHelper.computeResult(top, bottom).isEmpty();
    }

    public static Optional<Result> grindItem(Level level, ItemStack top, ItemStack bottom) {
        GrindstoneEvent.OnTakeItem take;
        GrindstoneEvent.OnPlaceItem place = (GrindstoneEvent.OnPlaceItem)NeoForge.EVENT_BUS.post((Event)new GrindstoneEvent.OnPlaceItem(top, ItemStack.EMPTY, -1));
        if (place.isCanceled()) {
            return Optional.empty();
        }
        int experience = place.getXp();
        ItemStack output = place.getOutput();
        if (output.isEmpty()) {
            output = GrindstoneHelper.computeResult(top, bottom);
            if (output.isEmpty()) {
                return Optional.empty();
            }
            if (experience == -1) {
                experience = GrindstoneHelper.getGrindingExperience(level, top, bottom);
            }
        }
        if ((take = (GrindstoneEvent.OnTakeItem)NeoForge.EVENT_BUS.post((Event)new GrindstoneEvent.OnTakeItem(top, bottom, experience))).isCanceled()) {
            return Optional.of(new Result(top, bottom, output, 0));
        }
        return Optional.of(new Result(take.getNewTopItem(), take.getNewBottomItem(), output, Math.max(take.getXp(), 0)));
    }

    private static int getGrindingExperience(Level level, ItemStack top, ItemStack bottom) {
        int experience = 0;
        experience += GrindstoneHelper.getExperienceFromItem(top);
        if ((experience += GrindstoneHelper.getExperienceFromItem(bottom)) > 0) {
            int average = Mth.ceil((double)((double)experience / 2.0));
            return average + level.random.nextInt(average);
        }
        return 0;
    }

    public static int getExperienceFromItem(ItemStack stack) {
        int result = 0;
        ItemEnchantments itemenchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack);
        for (Object2IntMap.Entry entry : itemenchantments.entrySet()) {
            Holder holder = (Holder)entry.getKey();
            int level = entry.getIntValue();
            if (holder.is(EnchantmentTags.CURSE)) continue;
            result += ((Enchantment)holder.value()).getMinCost(level);
        }
        return result;
    }

    public static int getExperienceFromGrindingRecipe(Level level, ItemStack stack) {
        SingleRecipeInput input = new SingleRecipeInput(stack);
        Optional grinding = SequencedAssemblyRecipe.getRecipe((Level)level, (RecipeInput)input, (RecipeType)CEIRecipes.GRINDING.getType(), GrindingRecipe.class);
        if (grinding.isEmpty()) {
            grinding = level.getRecipeManager().getRecipeFor(CEIRecipes.GRINDING.getType(), (RecipeInput)input, level);
        }
        if (grinding.isEmpty()) {
            return 0;
        }
        NonNullList f = ((GrindingRecipe)((RecipeHolder)grinding.get()).value()).getFluidResults();
        if (f.isEmpty()) {
            return 0;
        }
        return ((FluidStack)f.getFirst()).getAmount();
    }

    private static ItemStack computeResult(ItemStack top, ItemStack bottom) {
        boolean topEmpty = top.isEmpty();
        boolean bottomEmpty = bottom.isEmpty();
        if (topEmpty && bottomEmpty) {
            return ItemStack.EMPTY;
        }
        if (top.getCount() <= 1 && bottom.getCount() <= 1) {
            if (topEmpty || bottomEmpty) {
                ItemStack input = topEmpty ? bottom : top;
                return !EnchantmentHelper.hasAnyEnchantments((ItemStack)input) ? ItemStack.EMPTY : GrindstoneHelper.removeNonCursesFrom(input.copy());
            }
            return GrindstoneHelper.mergeItems(top, bottom);
        }
        return ItemStack.EMPTY;
    }

    private static ItemStack mergeItems(ItemStack top, ItemStack bottom) {
        ItemStack result;
        if (!top.is(bottom.getItem())) {
            return ItemStack.EMPTY;
        }
        int maxDamage = Math.max(top.getMaxDamage(), bottom.getMaxDamage());
        int topDurability = top.getMaxDamage() - top.getDamageValue();
        int bottomDurability = bottom.getMaxDamage() - bottom.getDamageValue();
        int l = topDurability + bottomDurability + maxDamage * 5 / 100;
        int count = 1;
        if (!top.isDamageableItem() || !top.isRepairable()) {
            if (top.getMaxStackSize() < 2 || !ItemStack.matches((ItemStack)top, (ItemStack)bottom)) {
                return ItemStack.EMPTY;
            }
            count = 2;
        }
        if ((result = top.copyWithCount(count)).isDamageableItem()) {
            result.set(DataComponents.MAX_DAMAGE, (Object)maxDamage);
            result.setDamageValue(Math.max(maxDamage - l, 0));
            if (!bottom.isRepairable()) {
                result.setDamageValue(top.getDamageValue());
            }
        }
        GrindstoneHelper.mergeEnchantsFrom(result, bottom);
        return GrindstoneHelper.removeNonCursesFrom(result);
    }

    private static void mergeEnchantsFrom(ItemStack top, ItemStack bottom) {
        EnchantmentHelper.updateEnchantments((ItemStack)top, topEnchantments -> {
            ItemEnchantments bottomEnchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)bottom);
            for (Object2IntMap.Entry entry : bottomEnchantments.entrySet()) {
                Holder holder = (Holder)entry.getKey();
                if (holder.is(EnchantmentTags.CURSE) && topEnchantments.getLevel(holder) != 0) continue;
                topEnchantments.upgrade(holder, entry.getIntValue());
            }
        });
    }

    public static ItemStack removeNonCursesFrom(ItemStack input) {
        ItemEnchantments itemenchantments = EnchantmentHelper.updateEnchantments((ItemStack)input, enchantments -> enchantments.removeIf(enchantment -> !enchantment.is(EnchantmentTags.CURSE)));
        if (input.is(Items.ENCHANTED_BOOK) && itemenchantments.isEmpty()) {
            input = input.transmuteCopy((ItemLike)Items.BOOK);
        }
        int repairCost = 0;
        for (int j = 0; j < itemenchantments.size(); ++j) {
            repairCost = AnvilMenu.calculateIncreasedRepairCost((int)repairCost);
        }
        input.set(DataComponents.REPAIR_COST, (Object)repairCost);
        return input;
    }

    public record Result(ItemStack top, ItemStack bottom, ItemStack output, int experience) {
    }
}

