/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.fluids.experience;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.content.fluids.transfer.GenericItemEmptying;
import java.util.Optional;
import net.createmod.catnip.data.Pair;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createenchantmentindustry.common.fluids.experience.ExperienceHelper;
import plus.dragons.createenchantmentindustry.common.registry.CEIDataMaps;

public record ExperienceFuel(int experience, boolean special, Optional<ItemStack> usingConvertTo) {
    public static final Codec<ExperienceFuel> INLINE_CODEC = ExtraCodecs.POSITIVE_INT.flatComapMap(ExperienceFuel::normal, fuel -> !fuel.special && fuel.usingConvertTo.isEmpty() ? DataResult.success((Object)fuel.experience()) : DataResult.error(() -> "ExperienceFuel " + String.valueOf(fuel) + " can not be encoded inline"));
    public static final Codec<ExperienceFuel> FULL_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.POSITIVE_INT.fieldOf("experience").forGetter(ExperienceFuel::experience), (App)Codec.BOOL.optionalFieldOf("special", (Object)false).forGetter(ExperienceFuel::special), (App)ItemStack.SINGLE_ITEM_CODEC.optionalFieldOf("using_convert_to").forGetter(ExperienceFuel::usingConvertTo)).apply((Applicative)instance, ExperienceFuel::new));
    public static final Codec<ExperienceFuel> CODEC = NeoForgeExtraCodecs.withAlternative(INLINE_CODEC, FULL_CODEC);

    public static ExperienceFuel normal(int experience) {
        return new ExperienceFuel(experience, false, Optional.empty());
    }

    public static ExperienceFuel normal(int experience, ItemStack usingConvertTo) {
        return new ExperienceFuel(experience, false, Optional.of(usingConvertTo));
    }

    public static ExperienceFuel special(int experience) {
        return new ExperienceFuel(experience, true, Optional.empty());
    }

    public static ExperienceFuel special(int experience, ItemStack usingConvertTo) {
        return new ExperienceFuel(experience, true, Optional.of(usingConvertTo));
    }

    @Nullable
    public static ExperienceFuel get(Level level, ItemStack stack) {
        ExperienceFuel fuel = (ExperienceFuel)stack.getItemHolder().getData(CEIDataMaps.EXPERIENCE_FUEL);
        if (fuel != null) {
            return fuel;
        }
        if (!GenericItemEmptying.canItemBeEmptied((Level)level, (ItemStack)stack)) {
            return null;
        }
        Pair emptying = GenericItemEmptying.emptyItem((Level)level, (ItemStack)stack, (boolean)true);
        FluidStack fluid = (FluidStack)emptying.getFirst();
        int experience = ExperienceHelper.getExperienceFromFluid(fluid);
        if (experience == 0) {
            return null;
        }
        ItemStack item = (ItemStack)emptying.getSecond();
        return ExperienceFuel.normal(experience, item);
    }
}

