/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.data.lang;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import plus.dragons.createdragonsplus.mixin.neoforge.ExistingFileHelperAccessor;

public class ForeignLanguageProvider
implements DataProvider {
    private final String modid;
    private final String templateLocale;
    private final PackOutput.PathProvider langPathProvider;
    private final ResourceManager resourceManager;

    public ForeignLanguageProvider(String modid, String templateLocale, PackOutput output, ExistingFileHelper existingFileHelper) {
        this.modid = modid;
        this.templateLocale = templateLocale;
        this.langPathProvider = output.createPathProvider(PackOutput.Target.RESOURCE_PACK, "lang");
        this.resourceManager = ((ExistingFileHelperAccessor)existingFileHelper).invokeGetManager(PackType.CLIENT_RESOURCES);
    }

    public ForeignLanguageProvider(String modid, PackOutput output, ExistingFileHelper existingFileHelper) {
        this(modid, "en_us", output, existingFileHelper);
    }

    protected CompletableFuture<JsonObject> getTemplateLocalization() {
        return CompletableFuture.supplyAsync(() -> {
            JsonObject jsonObject;
            File file = this.langPathProvider.json(ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)this.templateLocale)).toFile();
            FileInputStream inputStream = new FileInputStream(file);
            try {
                jsonObject = GsonHelper.parse((Reader)new InputStreamReader(inputStream));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw new JsonIOException((Throwable)exception);
                }
            }
            inputStream.close();
            return jsonObject;
        }, Util.backgroundExecutor());
    }

    protected CompletableFuture<JsonObject> getForeignTemplateLocalization(Resource resource) {
        return CompletableFuture.supplyAsync(() -> {
            JsonObject jsonObject;
            block8: {
                InputStream inputStream = resource.open();
                try {
                    jsonObject = GsonHelper.parse((Reader)new InputStreamReader(inputStream));
                    if (inputStream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException exception) {
                        throw new JsonIOException((Throwable)exception);
                    }
                }
                inputStream.close();
            }
            return jsonObject;
        }, Util.backgroundExecutor());
    }

    protected boolean isForeignLanguageFile(ResourceLocation location) {
        if (!this.modid.equals(location.getNamespace())) {
            return false;
        }
        String[] paths = location.getPath().split("/");
        if (paths.length != 2) {
            return false;
        }
        return paths[1].endsWith(".json") && !paths[1].equals(this.templateLocale + ".json");
    }

    protected JsonObject combine(JsonObject template, JsonObject foreign) {
        JsonObject result = new JsonObject();
        LinkedHashMap<String, JsonElement> unlocalized = new LinkedHashMap<String, JsonElement>();
        for (Map.Entry entry : template.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            if (foreign.has(key)) {
                result.add(key, foreign.get(key));
                continue;
            }
            unlocalized.put(key, value);
        }
        if (!unlocalized.isEmpty()) {
            result.addProperty("_comment.unlocalized", "Remove this line after finishing localization.");
            unlocalized.forEach((arg_0, arg_1) -> ((JsonObject)result).add(arg_0, arg_1));
        }
        return result;
    }

    protected void save(CachedOutput output, String locale, JsonObject result) {
        Path path = this.langPathProvider.json(ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)locale));
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            HashingOutputStream hashingOutputStream = new HashingOutputStream(Hashing.sha1(), (OutputStream)byteArrayOutputStream);
            try (JsonWriter jsonwriter = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)hashingOutputStream, StandardCharsets.UTF_8));){
                jsonwriter.setSerializeNulls(false);
                jsonwriter.setIndent(" ".repeat(Math.max(0, INDENT_WIDTH.get())));
                GsonHelper.writeValue((JsonWriter)jsonwriter, (JsonElement)result, (Comparator)KEY_COMPARATOR);
            }
            output.writeIfNeeded(path, byteArrayOutputStream.toByteArray(), hashingOutputStream.hash());
        }
        catch (IOException ioexception) {
            LOGGER.error("Failed to save file to {}", (Object)path, (Object)ioexception);
        }
    }

    public CompletableFuture<?> run(CachedOutput output) {
        CompletableFuture<JsonObject> readTemplate = this.getTemplateLocalization();
        CompletableFuture[] all = (CompletableFuture[])this.resourceManager.listResources("lang", this::isForeignLanguageFile).entrySet().stream().map(entry -> {
            String locale = ((ResourceLocation)entry.getKey()).getPath().split("/")[1].replace(".json", "");
            return ((CompletableFuture)readTemplate.thenCombineAsync(this.getForeignTemplateLocalization((Resource)entry.getValue()), this::combine, (Executor)Util.backgroundExecutor())).thenAcceptAsync(result -> this.save(output, locale, (JsonObject)result), (Executor)Util.backgroundExecutor());
        }).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(all);
    }

    public String getName() {
        return "ForeignLanguage";
    }
}

