/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.config;

import net.minecraft.Util;
import net.minecraft.util.Unit;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import plus.dragons.createcentralkitchen.config.CCKClientConfig;
import plus.dragons.createcentralkitchen.config.CCKCommonConfig;
import plus.dragons.createcentralkitchen.config.CCKRecipesConfig;
import plus.dragons.createdragonsplus.util.FieldsNullabilityUnknownByDefault;

@FieldsNullabilityUnknownByDefault
public class CCKConfig {
    private static final CCKCommonConfig COMMON_CONFIG = new CCKCommonConfig();
    private static final CCKClientConfig CLIENT_CONFIG = new CCKClientConfig();
    private static ModConfigSpec COMMON_SPEC;
    private static ModConfigSpec CLIENT_SPEC;

    public CCKConfig(ModContainer modContainer) {
        COMMON_SPEC = (ModConfigSpec)Util.make((Object)((ModConfigSpec)new ModConfigSpec.Builder().configure(builder -> {
            COMMON_CONFIG.registerAll((ModConfigSpec.Builder)builder);
            return Unit.INSTANCE;
        }).getValue()), spec -> modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)spec));
        CLIENT_SPEC = (ModConfigSpec)Util.make((Object)((ModConfigSpec)new ModConfigSpec.Builder().configure(builder -> {
            CLIENT_CONFIG.registerAll((ModConfigSpec.Builder)builder);
            return Unit.INSTANCE;
        }).getValue()), spec -> modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)spec));
    }

    public static CCKCommonConfig common() {
        return COMMON_CONFIG;
    }

    public static CCKClientConfig client() {
        return CLIENT_CONFIG;
    }

    public static CCKRecipesConfig recipes() {
        return CCKConfig.COMMON_CONFIG.recipes;
    }

    @SubscribeEvent
    public void onLoad(ModConfigEvent.Loading event) {
        IConfigSpec spec = event.getConfig().getSpec();
        if (spec == COMMON_SPEC) {
            COMMON_CONFIG.onLoad();
        } else if (spec == CLIENT_SPEC) {
            CLIENT_CONFIG.onLoad();
        }
    }

    @SubscribeEvent
    public void onReload(ModConfigEvent.Reloading event) {
        IConfigSpec spec = event.getConfig().getSpec();
        if (spec == COMMON_SPEC) {
            COMMON_CONFIG.onReload();
        } else if (spec == CLIENT_SPEC) {
            CLIENT_CONFIG.onReload();
        }
    }
}

