/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.clipboard;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.equipment.clipboard.ClipboardBlock;
import com.simibubi.create.content.equipment.clipboard.ClipboardScreen;
import com.simibubi.create.content.logistics.AddressEditBoxHelper;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import java.util.UUID;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ClipboardBlockEntity
extends SmartBlockEntity {
    public ItemStack dataContainer = AllBlocks.CLIPBOARD.asStack();
    private UUID lastEdit;

    public ClipboardBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.updateWrittenState();
    }

    public void onEditedBy(Player player) {
        this.lastEdit = player.getUUID();
        this.notifyUpdate();
        this.updateWrittenState();
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.level.isClientSide()) {
            CatnipServices.PLATFORM.executeOnClientOnly(() -> this::advertiseToAddressHelper);
        }
    }

    public void updateWrittenState() {
        boolean shouldBeWritten;
        BlockState blockState = this.getBlockState();
        if (!AllBlocks.CLIPBOARD.has(blockState)) {
            return;
        }
        if (this.level.isClientSide()) {
            return;
        }
        boolean isWritten = (Boolean)blockState.getValue((Property)ClipboardBlock.WRITTEN);
        boolean bl = shouldBeWritten = !this.dataContainer.getComponentsPatch().isEmpty();
        if (isWritten == shouldBeWritten) {
            return;
        }
        this.level.setBlockAndUpdate(this.worldPosition, (BlockState)blockState.setValue((Property)ClipboardBlock.WRITTEN, (Comparable)Boolean.valueOf(shouldBeWritten)));
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    @Override
    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        tag.put("Item", this.dataContainer.saveOptional(registries));
        if (clientPacket && this.lastEdit != null) {
            tag.putUUID("LastEdit", this.lastEdit);
        }
    }

    @Override
    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        this.dataContainer = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("Item"));
        if (!AllBlocks.CLIPBOARD.isIn(this.dataContainer)) {
            this.dataContainer = AllBlocks.CLIPBOARD.asStack();
        }
        if (clientPacket) {
            CatnipServices.PLATFORM.executeOnClientOnly(() -> () -> this.readClientSide(tag));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void readClientSide(CompoundTag tag) {
        Minecraft mc = Minecraft.getInstance();
        Screen screen = mc.screen;
        if (!(screen instanceof ClipboardScreen)) {
            return;
        }
        ClipboardScreen cs = (ClipboardScreen)screen;
        if (tag.contains("LastEdit") && tag.getUUID("LastEdit").equals(mc.player.getUUID())) {
            return;
        }
        if (!this.worldPosition.equals((Object)cs.targetedBlock)) {
            return;
        }
        cs.reopenWith(this.dataContainer);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void advertiseToAddressHelper() {
        AddressEditBoxHelper.advertiseClipboard(this);
    }
}

